/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CommandLine
implements Iterable<String> {
    private final List<String> command = new ArrayList<String>();
    private final CommandFormat format;

    public CommandLine(CommandFormat format) {
        this.format = Objects.requireNonNull(format, "Unspecified format");
    }

    public CommandFormat getFormat() {
        return this.format;
    }

    public void append(String item) {
        this.command.add(item);
    }

    public void appendClassPath(File ... paths) {
        String value = Stream.of(paths).map(File::toPath).map(CommandLine::toJavaPath).collect(Collectors.joining(File.pathSeparator));
        this.command.add("-cp");
        this.command.add(this.toQuotedIfNeeded(value));
    }

    public void appendNativeLibraryPath(File ... paths) {
        String value = Stream.of(paths).map(File::toPath).map(CommandLine::toJavaPath).collect(Collectors.joining(File.pathSeparator));
        this.command.add("-Djava.library.path=" + this.toQuotedIfNeeded(value));
    }

    public void append(Path path) {
        this.command.add(this.toQuotedIfNeeded(CommandLine.toJavaPath(path)));
    }

    public void appendJavaOption(String item) {
        this.command.add(item);
    }

    public void appendJavaOption(String itemKey, Path path) {
        this.command.add(itemKey + "=" + this.toQuotedIfNeeded(CommandLine.toJavaPath(path)));
    }

    public void appendSystemOption(String itemKey, String itemValue) {
        this.command.add("-D" + itemKey + "=" + this.toQuotedIfNeeded(itemValue));
    }

    @Override
    public Iterator<String> iterator() {
        return this.command.iterator();
    }

    public ListIterator<String> listIterator() {
        return this.command.listIterator();
    }

    public String toString() {
        return this.command.stream().collect(Collectors.joining(" "));
    }

    public String toString(String separator) {
        return this.command.stream().collect(Collectors.joining(separator));
    }

    public List<String> toList() {
        return List.copyOf(this.command);
    }

    private String toQuotedIfNeeded(String value) {
        if (this.format == CommandFormat.BatFile && value.indexOf(32) >= 0) {
            return CommandLine.toQuoted(value);
        }
        return value;
    }

    private static String toQuoted(String value) {
        return "\"" + value + "\"";
    }

    private static String toJavaPath(Path path) {
        return path.normalize().toAbsolutePath().toString().replace('\\', '/');
    }

    static enum CommandFormat {
        ProcessBuilder,
        BatFile;

    }
}

