/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.config.ContextService;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="context-service")
@I18n(value="context.service.manager")
@ConfiguredBy(value=Resources.class)
public class ContextServiceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ContextServiceManager.class);
    private static final String DESCRIPTION = "description";
    private String jndiName = null;
    private String description = null;
    private String contextInfoEnabled = Boolean.TRUE.toString();
    private String contextInfo = "Classloader,JNDI,Security,WorkArea";
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    public String getResourceType() {
        return "context-service";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode<Resources> configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply(configCode, resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.context.service.failed", "Context service {0} creation failed", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("create.context.service.success", "Context service {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("context.service.noJndiName", "No JNDI name defined for context service.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, ContextService.class);
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.contextInfoEnabled = (String)attributes.get("context-info-enabled");
        this.contextInfo = (String)attributes.get("context-info");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
    }

    private ContextService createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ContextService newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private ContextService createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ContextService contextService = (ContextService)param.createChild(ContextService.class);
        contextService.setJndiName(this.jndiName);
        if (this.description != null) {
            contextService.setDescription(this.description);
        }
        contextService.setContextInfoEnabled(this.contextInfoEnabled);
        contextService.setContextInfo(this.contextInfo);
        contextService.setEnabled(this.enabled);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = contextService.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                contextService.getProperty().add(prop);
            }
        }
        return contextService;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }

    public ResourceStatus delete(Resources resources, String jndiName, String target) throws Exception {
        if (jndiName == null) {
            String msg = localStrings.getLocalString("context.service.noJndiName", "No JNDI name defined for context service.");
            return new ResourceStatus(1, msg);
        }
        SimpleJndiName simpleJndiName = new SimpleJndiName(jndiName);
        Resource resource = resources.getResourceByName(ContextService.class, simpleJndiName);
        if (resource == null) {
            String msg = localStrings.getLocalString("delete.context.service.notfound", "A context service named {0} does not exist.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if ("system-all-req".equals(resource.getObjectType())) {
            String msg = localStrings.getLocalString("delete.concurrent.resource.notAllowed", "The {0} resource cannot be deleted as it is required to be configured in the system.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if (this.environment.isDas()) {
            if ("domain".equals(target)) {
                if (!this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).isEmpty()) {
                    String msg = localStrings.getLocalString("delete.context.service.resource-ref.exist", "This context service [ {0} ] is referenced in an instance/cluster target, use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(simpleJndiName, target)) {
                    String msg = localStrings.getLocalString("delete.context.service.no.resource-ref", "This context service [ {0} ] is not referenced in target [ {1} ]", new Object[]{jndiName, target});
                    return new ResourceStatus(1, msg);
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).size() > 1) {
                    String msg = localStrings.getLocalString("delete.context.service.multiple.resource-refs", "This context service [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            }
        }
        try {
            SingleConfigCode<Resources> configCode;
            if (!"domain".equals(target)) {
                this.resourceUtil.deleteResourceRef(simpleJndiName, target);
            }
            if (ConfigSupport.apply(configCode = param -> {
                ContextService resource1 = (ContextService)resources.getResourceByName(ContextService.class, simpleJndiName);
                return param.getResources().remove(resource1);
            }, resources) == null) {
                String msg = localStrings.getLocalString("delete.context.service.failed", "Context service {0} deletion failed", new Object[]{jndiName});
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("delete.context.service.failed", "Context service {0} deletion failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("delete.context.service.success", "Context service {0} deleted successfully", new Object[]{jndiName});
        return new ResourceStatus(0, msg);
    }
}

