/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.admin.ParameterMap;

@Consumes(value={"application/json"})
@Provider
public class JsonParameterMapProvider
implements MessageBodyReader<ParameterMap> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(ParameterMap.class);
    }

    public ParameterMap readFrom(Class<ParameterMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        try {
            JSONObject obj = new JSONObject(new String(in.readAllBytes(), StandardCharsets.UTF_8));
            Iterator iter = obj.keys();
            ParameterMap map = new ParameterMap();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                Object value = obj.get(k);
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    for (int i = 0; i < array.length(); ++i) {
                        map.add((Object)k, (Object)String.valueOf(array.get(i)));
                    }
                    continue;
                }
                map.add((Object)k, (Object)("" + value));
            }
            return map;
        }
        catch (Exception ex) {
            ParameterMap map = new ParameterMap();
            map.add((Object)"error", (Object)("Entity Parsing Error: " + ex.getMessage()));
            return map;
        }
    }
}

