/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.jmac;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.logging.LogDomains;
import jakarta.security.auth.message.MessagePolicy;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.helper.AuthMessagePolicy;
import org.glassfish.epicyro.data.AuthModuleConfig;
import org.glassfish.epicyro.data.AuthModulesLayerConfig;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.types.Property;

public class ConfigDomainParser
implements ConfigParser {
    private static final Logger _logger = LogDomains.getLogger(ConfigDomainParser.class, (String)"jakarta.enterprise.system.core.security");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{\\{(.*?)}}|\\$\\{(.*?)}");
    private final Map<String, AuthModulesLayerConfig> authModuleLayers = new HashMap<String, AuthModulesLayerConfig>();
    private final Set<String> layersWithDefault = new HashSet<String>();

    public void initialize(Object service) throws IOException {
        if (service == null && Globals.getDefaultHabitat() != null) {
            service = Globals.getDefaultHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
        }
        if (service instanceof SecurityService) {
            this.processServerConfig((SecurityService)service, this.authModuleLayers);
        }
    }

    public Map<String, AuthModulesLayerConfig> getAuthModuleLayers() {
        return this.authModuleLayers;
    }

    public Set<String> getLayersWithDefault() {
        return this.layersWithDefault;
    }

    private void processServerConfig(SecurityService service, Map<String, AuthModulesLayerConfig> newAuthModuleLayers) throws IOException {
        List messageSecurityConfigs = service.getMessageSecurityConfig();
        if (messageSecurityConfigs != null) {
            for (MessageSecurityConfig messageSecurityConfig : messageSecurityConfigs) {
                String authLayer = this.parseInterceptEntry(messageSecurityConfig, newAuthModuleLayers);
                List providers = messageSecurityConfig.getProviderConfig();
                if (providers == null) continue;
                for (ProviderConfig provider : providers) {
                    this.parseIDEntry(provider, newAuthModuleLayers, authLayer);
                }
            }
        }
    }

    private String parseInterceptEntry(MessageSecurityConfig msgConfig, Map<String, AuthModulesLayerConfig> newConfig) throws IOException {
        AuthModulesLayerConfig authModulesLayerConfig;
        String authLayer = msgConfig.getAuthLayer();
        String defaultServerID = msgConfig.getDefaultProvider();
        String defaultClientID = msgConfig.getDefaultClientProvider();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Intercept Entry: \n    intercept: " + authLayer + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if (defaultServerID != null || defaultClientID != null) {
            this.layersWithDefault.add(authLayer);
        }
        if ((authModulesLayerConfig = newConfig.get(authLayer)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        authModulesLayerConfig = new AuthModulesLayerConfig(defaultClientID, defaultServerID, null);
        newConfig.put(authLayer, authModulesLayerConfig);
        return authLayer;
    }

    private void parseIDEntry(ProviderConfig providerConfig, Map<String, AuthModulesLayerConfig> newConfig, String intercept) throws IOException {
        String providerId = providerConfig.getProviderId();
        String providerType = providerConfig.getProviderType();
        String moduleClass = providerConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(providerConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(providerConfig.getResponsePolicy());
        Map<String, Object> options = this.getModuleOptions(providerConfig);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ID Entry: \n    module class: " + moduleClass + "\n    id: " + providerId + "\n    type: " + providerType + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    options: " + options);
        }
        AuthModuleConfig AuthModuleConfig2 = new AuthModuleConfig(providerType, moduleClass, requestPolicy, responsePolicy, options);
        AuthModulesLayerConfig AuthModulesLayerConfig2 = newConfig.get(intercept);
        if (AuthModulesLayerConfig2 == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (AuthModulesLayerConfig2.getAuthModules() == null) {
            AuthModulesLayerConfig2.setIdMap(new HashMap());
        }
        AuthModulesLayerConfig2.getAuthModules().put(providerId, AuthModuleConfig2);
    }

    private String expand(String rawProperty) {
        Matcher propertyMatcher = PROPERTY_PATTERN.matcher(rawProperty);
        StringBuilder propertyBuilder = new StringBuilder();
        while (propertyMatcher.find()) {
            if (propertyMatcher.group(1) != null) {
                propertyMatcher.appendReplacement(propertyBuilder, Matcher.quoteReplacement(propertyMatcher.group()));
                continue;
            }
            String replacement = System.getProperty(propertyMatcher.group(2));
            if (replacement == null) {
                throw new IllegalStateException("No system property for " + propertyMatcher.group(2));
            }
            propertyMatcher.appendReplacement(propertyBuilder, Matcher.quoteReplacement(replacement));
        }
        propertyMatcher.appendTail(propertyBuilder);
        return propertyBuilder.toString();
    }

    private MessagePolicy parsePolicy(RequestPolicy policy) {
        if (policy == null) {
            return null;
        }
        return AuthMessagePolicy.getMessagePolicy((String)policy.getAuthSource(), (String)policy.getAuthRecipient());
    }

    private MessagePolicy parsePolicy(ResponsePolicy policy) {
        if (policy == null) {
            return null;
        }
        return AuthMessagePolicy.getMessagePolicy((String)policy.getAuthSource(), (String)policy.getAuthRecipient());
    }

    private Map<String, Object> getModuleOptions(ProviderConfig providerConfig) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        List properties = providerConfig.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                try {
                    options.put(property.getName(), this.expand(property.getValue()));
                }
                catch (IllegalStateException ee) {
                    _logger.log(Level.FINE, "jmac.unexpandedproperty");
                    options.put(property.getName(), property.getValue());
                }
            }
        }
        return options;
    }
}

