/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRES_NEW)
public class TransactionalInterceptorRequiresNew
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = -3843074402046047130L;
    private static final Logger _logger = Logger.getLogger("jakarta.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.INFO, "AS-JTA-00013");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            Transaction suspendedTransaction = null;
            if (this.getTransactionManager().getTransaction() != null) {
                _logger.log(Level.INFO, "AS-JTA-00014");
                suspendedTransaction = this.getTransactionManager().suspend();
            }
            try {
                this.getTransactionManager().begin();
                TransactionManager tm = this.getTransactionManager();
                if (tm instanceof TransactionManagerHelper) {
                    ((TransactionManagerHelper)tm).preInvokeTx(true);
                }
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, "AS-JTA-00015", exception);
                throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during begin " + exception, (Throwable)exception);
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                try {
                    TransactionManager tm = this.getTransactionManager();
                    if (tm instanceof TransactionManagerHelper) {
                        ((TransactionManagerHelper)tm).postInvokeTx(false, true);
                    }
                    if (this.getTransactionManager().getTransaction().getStatus() == 1) {
                        this.getTransactionManager().rollback();
                    } else {
                        this.getTransactionManager().commit();
                    }
                }
                catch (Exception exception) {
                    _logger.log(Level.INFO, "AS-JTA-00016", exception);
                    throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during commit " + exception, (Throwable)exception);
                }
                if (suspendedTransaction != null) {
                    try {
                        this.getTransactionManager().resume(suspendedTransaction);
                    }
                    catch (Exception exception) {
                        _logger.log(Level.INFO, "AS-JTA-00017", exception);
                        throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during resume " + exception, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

