/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.extras.osgicontainer.OSGiArchiveDetector;
import org.glassfish.internal.deployment.GenericHandler;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="osgi")
@Singleton
public class OSGiArchiveHandler
extends GenericHandler
implements CompositeHandler {
    @LoggerInfo(subsystem="OSGI", description="OSGI container logger", publish=true)
    private static final String LOGGER_NAME = "jakarta.enterprise.osgi.container";
    @LogMessagesResourceBundle
    public static final String RB_NAME = "org.glassfish.extras.osgicontainer.LogMessages";
    private static Logger logger = Logger.getLogger("jakarta.enterprise.osgi.container", "org.glassfish.extras.osgicontainer.LogMessages");
    @LogMessageInfo(message="Decorated url = {0}", level="INFO")
    public static final String DECORATED_URL = "NCLS-OSGI-00001";
    @Inject
    private OSGiArchiveDetector detector;
    private final String URI_SCHEME_PROP_NAME = "UriScheme";
    private final char QUERY_PARAM_SEP = (char)38;
    private final String QUERY_DELIM = "?";
    private final String SCHEME_SEP = ":";

    public String getArchiveType() {
        return "osgi";
    }

    public boolean accept(ReadableArchive source, String entryName) {
        return false;
    }

    public void initCompositeMetaData(DeploymentContext context) {
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        return parent;
    }

    public String getDefaultApplicationName(ReadableArchive archive, DeploymentContext context) {
        return this.getDefaultApplicationNameFromArchiveName(archive);
    }

    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        Properties props = ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).properties;
        if (props != null && props.containsKey("UriScheme")) {
            URL url = this.prepareUrl(context, props);
            logger.log(Level.INFO, DECORATED_URL, url);
            try (JarInputStream jis = new JarInputStream(url.openStream());){
                this.expandJar(jis, target);
            }
        } else {
            super.expand(source, target, context);
        }
    }

    private URL prepareUrl(DeploymentContext context, Properties props) throws MalformedURLException {
        logger.logp(Level.FINE, "OSGiArchiveHandler", "prepareUrl", "Deployment properties = {0}", new Object[]{props});
        String uriScheme = props.getProperty("UriScheme");
        URI embeddedUri = context.getOriginalSource().getURI();
        StringBuilder query = new StringBuilder();
        Enumeration<?> p = props.propertyNames();
        while (p.hasMoreElements()) {
            String key = (String)p.nextElement();
            if ("UriScheme".equalsIgnoreCase(key)) continue;
            query.append(key);
            query.append("=");
            query.append(props.getProperty(key));
            query.append('&');
        }
        int lastIdx = query.length() - 1;
        if (query.charAt(lastIdx) == '&') {
            query.deleteCharAt(lastIdx);
        }
        String decoratedUriStr = uriScheme + ":" + embeddedUri + "?" + query;
        logger.logp(Level.FINE, "OSGiArchiveHandler", "prepareUrl", "Constructing a new URL from string [{0}]", new Object[]{decoratedUriStr});
        try {
            return new URI(decoratedUriStr).toURL();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandJar(JarInputStream jis, WritableArchive target) throws IOException {
        JarEntry je;
        while ((je = jis.getNextJarEntry()) != null) {
            try {
                if (je.isDirectory()) {
                    logger.logp(Level.FINER, "OSGiArchiveHandler", "expandJar", "Skipping jar entry = {0} since this is of directiry type", new Object[]{je});
                    continue;
                }
                String entryName = je.getName();
                long entrySize = je.getSize();
                logger.logp(Level.FINER, "OSGiArchiveHandler", "expandJar", "Writing jar entry name = {0}, size = {1}", new Object[]{entryName, entrySize});
                WritableArchiveEntry os = target.putNextEntry(entryName);
                try {
                    FileUtils.copy((InputStream)jis, (OutputStream)os);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            finally {
                jis.closeEntry();
            }
        }
        Manifest m = jis.getManifest();
        if (m != null) {
            logger.logp(Level.FINER, "OSGiArchiveHandler", "expandJar", "Writing manifest entry");
            try (WritableArchiveEntry os = target.putNextEntry("META-INF/MANIFEST.MF");){
                m.write((OutputStream)os);
            }
        }
    }

    public boolean requiresAnnotationScanning(ReadableArchive archive) {
        return false;
    }
}

