/*
 * Copyright 2010, Red Hat, Inc., and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.extensions.container.event.jms;

import jakarta.inject.Inject;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

public class QueueMessageDrivenBean implements MessageListener {

    @Inject
    private Sheep sheep;

    @SuppressWarnings("unused")
    private boolean initializerCalled = false;

    @Inject
    public void initialize(Sheep sheep) {
        initializerCalled = sheep != null;
    }

    @Override
    public void onMessage(Message message) {
    }

}
