/*
 * Copyright 2010, Red Hat, Inc., and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.extensions.container.event;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;

public class ProcessInjectionTargetObserver implements Extension {
    private static AnnotatedType<Sheep> statelessSessionBeanType = null;
    private static AnnotatedType<Cow> statefulSessionBeanType = null;
    private static AnnotatedType<SheepInterceptor> sessionBeanInterceptorType = null;
    private static AnnotatedType<Farm> managedBeanType = null;

    public void cleanup(@Observes BeforeShutdown shutdown) {
        statefulSessionBeanType = null;
        statelessSessionBeanType = null;
        sessionBeanInterceptorType = null;
        managedBeanType = null;
    }

    public void observeStatelessSessionBean(@Observes ProcessInjectionTarget<Sheep> event) {
        statelessSessionBeanType = event.getAnnotatedType();
    }

    public void observeStatefulSessionBean(@Observes ProcessInjectionTarget<Cow> event) {
        statefulSessionBeanType = event.getAnnotatedType();
    }

    public void observeSessionBeanInterceptor(@Observes ProcessInjectionTarget<SheepInterceptor> event) {
        sessionBeanInterceptorType = event.getAnnotatedType();
    }

    public void observeManagedBean(@Observes ProcessInjectionTarget<Farm> event) {
        managedBeanType = event.getAnnotatedType();
    }

    public static AnnotatedType<Sheep> getStatelessSessionBeanType() {
        return statelessSessionBeanType;
    }

    public static AnnotatedType<Cow> getStatefulSessionBeanType() {
        return statefulSessionBeanType;
    }

    public static AnnotatedType<SheepInterceptor> getSessionBeanInterceptorType() {
        return sessionBeanInterceptorType;
    }

    public static AnnotatedType<Farm> getManagedBeanType() {
        return managedBeanType;
    }
}