/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.invokers.invalid;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="4.1")
public class DecoratorInvokerTest
extends AbstractTest {
    @Deployment
    @ShouldThrowException(value=DeploymentException.class)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(DecoratorInvokerTest.class)).withClasses(MyService.class, MyDecorator.class)).withExtension(TestExtension.class)).build();
    }

    @Test
    @SpecAssertion(section="building_invoker_full", id="a")
    public void trigger() {
    }

    public static interface MyService {
        public String hello();
    }

    @Decorator
    @Priority(value=1)
    public static class MyDecorator
    implements MyService {
        @Inject
        @Delegate
        MyService delegate;

        @Override
        public String hello() {
            return "decorated: " + this.delegate.hello();
        }
    }

    public static class TestExtension
    implements Extension {
        public void myDecoratorRegistration(@Observes ProcessManagedBean<MyDecorator> pmb) {
            pmb.getAnnotatedBeanClass().getMethods().stream().filter(it -> "hello".equals(it.getJavaMember().getName())).forEach(it -> pmb.createInvoker(it).build());
        }
    }
}

