/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct;

import jakarta.enterprise.inject.Instance;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.Alpha;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.AlphaInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.Bravo;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.BravoInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.Charlie;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.CharlieException;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.CharlieInterceptor1;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundConstruct.CharlieInterceptor2;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class AroundConstructTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AroundConstructTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="constructor_and_method_level_int", id="ab"), @SpecAssertion(section="invocationcontext", id="c"), @SpecAssertion(section="invocationcontext", id="eb"), @SpecAssertion(section="invocationcontext", id="f"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="a"), @SpecAssertion(section="associating_int_using_interceptors_annotation", id="c")})
    public void testInterceptorInvocation(Instance<Alpha> instance) {
        ActionSequence.reset();
        instance.get();
        ActionSequence.assertSequenceDataEquals(AlphaInterceptor.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="invocationcontext", id="ga")
    public void testReplacingParameters(Instance<Bravo> instance) {
        ActionSequence.reset();
        Bravo bravo = (Bravo)instance.get();
        Assert.assertNotNull((Object)bravo.getParameter());
        Assert.assertEquals((String)"enhanced parameter1", (String)bravo.getParameter().getValue());
        ActionSequence.assertSequenceDataEquals(BravoInterceptor.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="def_of_interceptor_classes_and_interceptor_methods", id="b"), @SpecAssertion(section="lic_exceptions", id="a"), @SpecAssertion(section="lic_exceptions", id="b")})
    public void testExceptions(Instance<Charlie> instance) {
        ActionSequence.reset();
        try {
            instance.get();
            Assert.fail();
        }
        catch (CharlieException e) {
            ActionSequence.assertSequenceDataEquals(CharlieInterceptor2.class, CharlieInterceptor1.class);
        }
        catch (Throwable e) {
            Assert.fail();
        }
    }
}

