/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.build.compatible.extensions.syntheticBean;

import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.build.compatible.extensions.syntheticBean.MyComplexValue;
import org.jboss.cdi.tck.tests.build.compatible.extensions.syntheticBean.MyEnum;
import org.jboss.cdi.tck.tests.build.compatible.extensions.syntheticBean.MyPojoDisposer;
import org.jboss.cdi.tck.tests.build.compatible.extensions.syntheticBean.MyService;
import org.jboss.cdi.tck.tests.build.compatible.extensions.syntheticBean.SyntheticBeanExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.0")
public class SyntheticBeanTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SyntheticBeanTest.class)).withBuildCompatibleExtension(SyntheticBeanExtension.class)).build();
    }

    @Test
    @SpecAssertion(section="synthesis_phase", id="a")
    public void test() {
        Instance lookup = this.getCurrentBeanContainer().createInstance();
        Instance.Handle handle = lookup.select(MyService.class, new Annotation[0]).getHandle();
        MyService myService = (MyService)handle.get();
        Assert.assertEquals((String)"Hello World", (String)myService.unqualified.text);
        MyComplexValue ann = myService.unqualified.ann;
        Assert.assertNotNull((Object)ann);
        Assert.assertEquals((int)42, (int)ann.number());
        Assert.assertEquals((Object)((Object)MyEnum.YES), (Object)((Object)ann.enumeration()));
        Assert.assertEquals(MyEnum.class, ann.type());
        Assert.assertEquals((String)"yes", (String)ann.nested().value());
        Assert.assertEquals((byte[])new byte[]{4, 5, 6}, (byte[])ann.nested().bytes());
        Assert.assertEquals((String)"Hello @MyQualifier Special", (String)myService.qualified.text);
        ann = myService.qualified.ann;
        Assert.assertNotNull((Object)ann);
        Assert.assertEquals((int)13, (int)ann.number());
        Assert.assertEquals((Object)((Object)MyEnum.NO), (Object)((Object)ann.enumeration()));
        Assert.assertEquals(MyEnum.class, ann.type());
        Assert.assertEquals((String)"no", (String)ann.nested().value());
        Assert.assertEquals((byte[])new byte[]{1, 2, 3}, (byte[])ann.nested().bytes());
        Assert.assertEquals((int)0, (int)MyPojoDisposer.disposed.size());
        handle.destroy();
        Assert.assertEquals((int)2, (int)MyPojoDisposer.disposed.size());
        Assert.assertTrue((boolean)MyPojoDisposer.disposed.contains("Hello World"));
        Assert.assertTrue((boolean)MyPojoDisposer.disposed.contains("Hello @MyQualifier Special"));
    }
}

