/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.conversation.AbstractConversationTest;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;
import org.jboss.cdi.tck.tests.context.conversation.CloudController;
import org.jboss.cdi.tck.tests.context.conversation.ConversationStatusServlet;
import org.jboss.cdi.tck.tests.context.conversation.ConversationTestPhaseListener;
import org.jboss.cdi.tck.tests.context.conversation.OutermostFilter;
import org.jboss.cdi.tck.tests.context.conversation.Storm;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class ManualCidPropagationTest
extends AbstractConversationTest {
    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassDefinition(ManualCidPropagationTest.class)).withClasses(new Class[]{Storm.class, ConversationTestPhaseListener.class, ConversationStatusServlet.class, Cloud.class, CloudController.class, OutermostFilter.class})).withWebResource("cloud.xhtml")).withWebResource("storm.xhtml")).withWebResource("clouds.xhtml")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebXml("web.xml")).build();
    }

    @Test
    @SpecAssertion(section="conversation_context_ee", id="n")
    public void testManualCidPropagation() throws Exception {
        WebClient webClient = new WebClient();
        HtmlPage storm = (HtmlPage)webClient.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        String c1 = this.getCid((Page)storm);
        HtmlPage cloud = (HtmlPage)webClient.getPage(this.getPath("cloud.jsf", c1));
        String c2 = this.getCid((Page)cloud);
        assert (this.isLongRunning((Page)cloud).booleanValue());
        assert (c1.equals(c2));
    }
}

