/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.Alternatives;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.Logger;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.Monitored;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.TransactionLogger;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.AfterTypeBeanDiscoveryMassOperationObserver;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.AlphaAlternative;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.AlphaDecorator;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.AlphaInterceptor;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.BetaAlternative;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.BetaDecorator;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.BetaInterceptor;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.GammaAlternative;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.GammaDecorator;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.atd.massOperations.GammaInterceptor;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
public class AfterTypeDiscoveryMassOperationsTest
extends AbstractTest {
    @Inject
    AfterTypeBeanDiscoveryMassOperationObserver extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AfterTypeDiscoveryMassOperationsTest.class)).withClasses(TransactionLogger.class, Logger.class, Monitored.class, Alternatives.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).withExtension(AfterTypeBeanDiscoveryMassOperationObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="a"), @SpecAssertion(section="after_type_discovery", id="c"), @SpecAssertion(section="after_type_discovery", id="hb")})
    public void testInitialInterceptors() {
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(AlphaInterceptor.class));
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(BetaInterceptor.class));
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(GammaInterceptor.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="b"), @SpecAssertion(section="after_type_discovery", id="ha")})
    public void testInitialAlternatives() {
        Assert.assertTrue((this.extension.getAlternatives().size() >= 3 ? 1 : 0) != 0);
        List<Class<?>> alternatives = this.extension.getAlternatives();
        Integer alphaAltIndex = null;
        Integer betaLatIndex = null;
        Integer gammaAltIndex = null;
        for (int i = 0; i < alternatives.size(); ++i) {
            if (alternatives.get(i).equals(AlphaAlternative.class)) {
                alphaAltIndex = i;
            }
            if (alternatives.get(i).equals(BetaAlternative.class)) {
                betaLatIndex = i;
            }
            if (!alternatives.get(i).equals(GammaAlternative.class)) continue;
            gammaAltIndex = i;
        }
        Assert.assertNotNull(alphaAltIndex);
        Assert.assertNotNull(betaLatIndex);
        Assert.assertNotNull(gammaAltIndex);
        Assert.assertTrue((alphaAltIndex < betaLatIndex ? 1 : 0) != 0);
        Assert.assertTrue((betaLatIndex < gammaAltIndex ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="d"), @SpecAssertion(section="after_type_discovery", id="hc")})
    public void testInitialDecorators() {
        Assert.assertTrue((this.extension.getDecorators().size() >= 3 ? 1 : 0) != 0);
        List<Class<?>> decorators = this.extension.getDecorators();
        Integer alphaDecIndex = null;
        Integer betaDecIndex = null;
        Integer gammaDecIndex = null;
        for (int i = 0; i < decorators.size(); ++i) {
            if (decorators.get(i).equals(AlphaDecorator.class)) {
                alphaDecIndex = i;
            }
            if (decorators.get(i).equals(BetaDecorator.class)) {
                betaDecIndex = i;
            }
            if (!decorators.get(i).equals(GammaDecorator.class)) continue;
            gammaDecIndex = i;
        }
        Assert.assertNotNull(alphaDecIndex);
        Assert.assertNotNull(betaDecIndex);
        Assert.assertNotNull(gammaDecIndex);
        Assert.assertTrue((alphaDecIndex < betaDecIndex ? 1 : 0) != 0);
        Assert.assertTrue((betaDecIndex < gammaDecIndex ? 1 : 0) != 0);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="gb")})
    public void testFinalInterceptors(TransactionLogger logger) {
        AlphaInterceptor.reset();
        BetaInterceptor.reset();
        GammaInterceptor.reset();
        logger.ping();
        Assert.assertTrue((boolean)AlphaInterceptor.isIntercepted());
        Assert.assertTrue((boolean)BetaInterceptor.isIntercepted());
        Assert.assertTrue((boolean)GammaInterceptor.isIntercepted());
        Assert.assertTrue((boolean)this.extension.containsWorks());
        Assert.assertTrue((boolean)this.extension.containsAllWorks());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="gc")})
    public void testFinalDecorators(TransactionLogger logger) {
        Assert.assertEquals((String)logger.log("ping"), (String)"pinggamma");
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="ga")})
    public void testFinalAlternatives(TransactionLogger logger) {
        Assert.assertEquals((Object)logger.getAlternativeClass(), GammaAlternative.class);
        Assert.assertTrue((boolean)this.getBeans(AlphaAlternative.class, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.getBeans(BetaAlternative.class, new Annotation[0]).isEmpty());
    }
}

