/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.enterprise;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.FarmerLocal;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.Landowner;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.Lazy;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.LazyFarmer;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.LazyFarmerLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class EnterpriseBeanSpecializationTest
extends AbstractTest {
    private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanSpecializationTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization_ee", id="ia"), @SpecAssertion(section="specialize_session_bean", id="aa")})
    public void testDirectSpecialization() {
        Set<Bean<LazyFarmerLocal>> farmerBeans = this.getBeans(LazyFarmerLocal.class, LANDOWNER_LITERAL);
        Assert.assertEquals((int)farmerBeans.size(), (int)1);
        Bean<LazyFarmerLocal> lazyFarmerBean = farmerBeans.iterator().next();
        Assert.assertEquals((Object)lazyFarmerBean.getBeanClass(), LazyFarmer.class);
        Set lazyFarmerBeanTypes = lazyFarmerBean.getTypes();
        Assert.assertEquals((int)lazyFarmerBeanTypes.size(), (int)3);
        Assert.assertTrue((boolean)this.typeSetMatches(lazyFarmerBeanTypes, new Type[]{Object.class, FarmerLocal.class, LazyFarmerLocal.class}));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization_ee", id="j")})
    public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean() {
        Set<Bean<LazyFarmerLocal>> farmerBeans = this.getBeans(LazyFarmerLocal.class, LANDOWNER_LITERAL);
        Assert.assertEquals((int)farmerBeans.size(), (int)1);
        Bean<LazyFarmerLocal> lazyFarmerBean = farmerBeans.iterator().next();
        Assert.assertEquals((int)lazyFarmerBean.getQualifiers().size(), (int)4);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)lazyFarmerBean.getQualifiers(), Landowner.class, Lazy.class, Any.class, Named.class));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization_ee", id="k")})
    public void testSpecializingBeanHasNameOfSpecializedBean() {
        String expectedName = "farmer";
        Set beans = this.getCurrentManager().getBeans(expectedName);
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean farmerBean = (Bean)beans.iterator().next();
        Assert.assertEquals((String)farmerBean.getName(), (String)expectedName);
        Assert.assertEquals((Object)farmerBean.getBeanClass(), LazyFarmer.class);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="specialize_session_bean", id="ca")})
    public void testSpecializedBeanNotInstantiated(@Landowner FarmerLocal farmer) throws Exception {
        Assert.assertEquals((String)farmer.getClassName(), (String)LazyFarmer.class.getName());
    }
}

