/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.aroundConstruct;

import jakarta.enterprise.inject.Instance;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.aroundConstruct.Baz;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.aroundConstruct.Baz2Interceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.aroundConstruct.Foo;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.aroundConstruct.FooCommonInterceptor;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class AroundConstructLifeCycleTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AroundConstructLifeCycleTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="interceptor_lifecycle", id="da")
    public void testAroundConstructInvokedAfterDependencyInjectionOnInterceptorClasses(Instance<Foo> instance) {
        FooCommonInterceptor.reset();
        instance.get();
        Assert.assertTrue((boolean)FooCommonInterceptor.commonAroundConstructCalled);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="interceptor_lifecycle", id="db"), @SpecAssertion(section="interceptor_lifecycle", id="dc")})
    public void testInstanceNotCreatedUnlessInvocationContextProceedCalled(Instance<Baz> instance) {
        Baz2Interceptor.setProceed(false);
        Assert.assertFalse((boolean)Baz.postConstructedCalled, (String)"Instance created even though InvocationContext.proceed() was not called.");
        Baz2Interceptor.setProceed(true);
        Baz baz = (Baz)instance.get();
        Assert.assertNotNull((Object)baz, (String)"Instance not created even though InvocationContext.proceed() was called.");
        Assert.assertTrue((boolean)baz.accessed);
        Assert.assertTrue((boolean)baz.injectionPerformedCorrectly());
    }
}

