/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional;

import jakarta.annotation.Resource;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.transaction.UserTransaction;
import org.jboss.cdi.tck.tests.event.observer.transactional.Failure;
import org.jboss.cdi.tck.tests.event.observer.transactional.Withdrawal;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;

public class AccountTransactionObserver {
    private static final SimpleLogger logger = new SimpleLogger(AccountTransactionObserver.class);
    @Resource
    private UserTransaction userTransaction;

    public void withdrawAfterSuccess(@Observes(during=TransactionPhase.AFTER_SUCCESS) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_SUCCESS);
    }

    public void withdrawAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_COMPLETION);
    }

    public void withdrawBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.BEFORE_COMPLETION);
    }

    public void withdrawNoTx(@Observes(during=TransactionPhase.IN_PROGRESS) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.IN_PROGRESS);
    }

    public void withdrawAfterFailure(@Observes(during=TransactionPhase.AFTER_FAILURE) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_FAILURE);
    }

    public void failBeforeCompletion(@Observes(during=TransactionPhase.IN_PROGRESS) Failure failure) throws Exception {
        this.logEventFired(TransactionPhase.IN_PROGRESS);
        this.userTransaction.setRollbackOnly();
    }

    private void logEventFired(TransactionPhase phase) {
        logger.log(phase.toString(), new Object[0]);
        ActionSequence.addAction(phase.toString());
    }
}

