/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.atd;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AfterTypeDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AlphaAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AlphaDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AlphaInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.BravoDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.BravoInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.CharlieAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.CharlieDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.CharlieInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.EchoAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.EchoDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.EchoInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.TransactionLogger;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Bar;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Baz;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Boss;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Foo;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Pro;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class AfterTypeDiscoveryTest
extends AbstractTest {
    @Inject
    AfterTypeDiscoveryObserver extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AfterTypeDiscoveryTest.class)).withExtension(AfterTypeDiscoveryObserver.class)).withLibrary(Boss.class, Foo.class, Bar.class, Baz.class, Pro.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{CharlieInterceptor.class.getName()}).up()).getOrCreateDecorators().clazz(new String[]{CharlieDecorator.class.getName()}).up()).getOrCreateAlternatives().clazz(new String[]{CharlieAlternative.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="a"), @SpecAssertion(section="after_type_discovery", id="c"), @SpecAssertion(section="after_type_discovery", id="hb")})
    public void testInitialInterceptors() {
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(BravoInterceptor.class));
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(AlphaInterceptor.class));
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(DeltaInterceptor.class));
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(EchoInterceptor.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="b"), @SpecAssertion(section="after_type_discovery", id="ha")})
    public void testInitialAlternatives() {
        Assert.assertEquals((int)this.extension.getAlternatives().size(), (int)3);
        Assert.assertEquals(this.extension.getAlternatives().get(0), AlphaAlternative.class);
        Assert.assertEquals(this.extension.getAlternatives().get(1), EchoAlternative.class);
        Assert.assertEquals(this.extension.getAlternatives().get(2), DeltaAlternative.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="d"), @SpecAssertion(section="after_type_discovery", id="hc")})
    public void testInitialDecorators() {
        Assert.assertEquals((int)this.extension.getDecorators().size(), (int)4);
        Assert.assertEquals(this.extension.getDecorators().get(0), AlphaDecorator.class);
        Assert.assertEquals(this.extension.getDecorators().get(1), BravoDecorator.class);
        Assert.assertEquals(this.extension.getDecorators().get(2), EchoDecorator.class);
        Assert.assertEquals(this.extension.getDecorators().get(3), DeltaDecorator.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="gb")})
    public void testFinalInterceptors(TransactionLogger logger) {
        AlphaInterceptor.reset();
        BravoInterceptor.reset();
        CharlieInterceptor.reset();
        DeltaInterceptor.reset();
        EchoInterceptor.reset();
        logger.ping();
        Assert.assertTrue((boolean)AlphaInterceptor.isIntercepted());
        Assert.assertFalse((boolean)BravoInterceptor.isIntercepted());
        Assert.assertTrue((boolean)CharlieInterceptor.isIntercepted());
        Assert.assertTrue((boolean)DeltaInterceptor.isIntercepted());
        Assert.assertFalse((boolean)EchoInterceptor.isIntercepted());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="gc")})
    public void testFinalDecorators(TransactionLogger logger) {
        Assert.assertEquals((String)logger.log("ping"), (String)"pingdeltabravoalphacharlie");
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="ga")})
    public void testFinalAlternatives(TransactionLogger logger) {
        Assert.assertEquals((Object)logger.getAlternativeClass(), DeltaAlternative.class);
        Assert.assertTrue((boolean)this.getBeans(AlphaAlternative.class, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.getBeans(EchoAlternative.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="e"), @SpecAssertion(section="type_discovery_steps", id="d")})
    public void testAddAnnotatedType() {
        Assert.assertTrue((boolean)this.extension.isBossObserved());
        this.getUniqueBean(Boss.class, new Annotation[0]);
        Assert.assertEquals((int)this.getBeans(Bar.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Bar.class, new Annotation[]{new AnnotationLiteral<Pro>(){}}).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Foo.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Foo.class, new Annotation[]{new AnnotationLiteral<Pro>(){}}).size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="ea")})
    public void testAddAnnotatedTypeWithConfigurator() {
        Bean<Baz> bazBean = this.getUniqueBean(Baz.class, Pro.ProLiteral.INSTANCE);
        Assert.assertEquals((Object)bazBean.getScope(), RequestScoped.class);
        Baz baz = (Baz)this.getCurrentManager().getReference(bazBean, Baz.class, this.getCurrentManager().createCreationalContext(bazBean));
        Assert.assertFalse((boolean)baz.getBarInstance().isUnsatisfied());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_producer", id="ab"), @SpecAssertion(section="process_producer", id="bb")})
    public void testProcessProducerEventFiredForProducerField() {
        Assert.assertTrue((boolean)this.extension.isProcessProcuderFieldObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_producer", id="aa"), @SpecAssertion(section="process_producer", id="ba")})
    public void testProcessProducerEventFiredForProducerMethod() {
        Assert.assertTrue((boolean)this.extension.isProcessProcuderMethodObserved());
    }
}

