/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.discovery.trimmed;

import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.Bar;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.BarInterceptor;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.BarInterceptorBinding;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.BarProducer;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.Foo;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.FooProducer;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.TestExtension;
import org.jboss.cdi.tck.tests.se.discovery.trimmed.TestStereotype;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0")
public class TrimmedBeanArchiveSETest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() {
        JavaArchive trimmed = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TrimmedBeanArchiveSETest.class, Bar.class, Foo.class, BarProducer.class, FooProducer.class, TestStereotype.class, TestExtension.class, BarInterceptor.class, BarInterceptorBinding.class})).addAsServiceProvider(Extension.class, new Class[]{TestExtension.class})).addAsManifestResource(TrimmedBeanArchiveSETest.class.getPackage(), "beans.xml", "beans.xml");
        return ClassPath.builder().add(trimmed).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="trimmed_bean_archive", id="a"), @SpecAssertion(section="binding_interceptor_to_bean", id="c"), @SpecAssertion(section="interception_factory", id="ca")})
    public void discoveredTypes() {
        try (SeContainer seContainer = SeContainerInitializer.newInstance().initialize();){
            Bar bar = (Bar)seContainer.select(Bar.class, new Annotation[0]).get();
            Foo foo = (Foo)seContainer.select(Foo.class, new Annotation[0]).get();
            Assert.assertNotNull((Object)foo);
            Assert.assertNotNull((Object)bar);
            Assert.assertEquals((String)bar.ping(), (String)"Intercepted Bar");
            TestExtension ext = (TestExtension)seContainer.select(TestExtension.class, new Annotation[0]).get();
            Assert.assertTrue((boolean)ext.getBarPATFired());
            Assert.assertTrue((boolean)ext.getBarProducerPBAFired());
            Assert.assertFalse((boolean)ext.getBarPBFired());
        }
    }
}

