/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.common.ui.PropertiesTableViewer;
import org.eclipse.emf.edapt.common.ui.StructureTreeViewer;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class ModelSash
extends SashForm {
    private StructureTreeViewer structureViewer;
    private PropertiesTableViewer propertiesViewer;
    private final AdapterFactory adapterFactory;

    public ModelSash(Composite parent, int style) {
        super(parent, style | 0x200);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = adapterFactory;
        this.init();
    }

    public ModelSash(Composite parent, int style, AdapterFactory adapterFactory) {
        super(parent, style | 0x200);
        this.adapterFactory = adapterFactory;
        this.init();
    }

    private void init() {
        this.structureViewer = new StructureTreeViewer((Composite)this, 0, this.adapterFactory);
        this.propertiesViewer = new PropertiesTableViewer((Composite)this, 0, this.adapterFactory);
        this.structureViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                if (!structuredSelection.isEmpty() && structuredSelection.getFirstElement() instanceof EObject) {
                    EObject before = (EObject)structuredSelection.getFirstElement();
                    ModelSash.this.propertiesViewer.setElement(before);
                } else {
                    ModelSash.this.propertiesViewer.setInput(null);
                }
            }
        });
        this.propertiesViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                PropertyDescriptor descriptor = (PropertyDescriptor)item.getData();
                PropertySource propertySource = (PropertySource)ModelSash.this.propertiesViewer.getInput();
                Object value = propertySource.getPropertyValue(descriptor.getId());
                if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
                    ItemPropertyDescriptor.PropertyValueWrapper wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)value;
                    value = wrapper.getEditableValue(value);
                    ModelSash.this.propertyValuesSelected(value);
                }
            }
        });
        this.setWeights(new int[]{2, 1});
    }

    protected void propertyValuesSelected(Object value) {
        if (value instanceof EObject) {
            this.structureViewer.setSelection((ISelection)new StructuredSelection(value), true);
        } else if (value instanceof List) {
            this.structureViewer.setSelection((ISelection)new StructuredSelection((List)value), true);
        }
    }

    public StructureTreeViewer getStructureViewer() {
        return this.structureViewer;
    }

    public PropertiesTableViewer getPropertiesViewer() {
        return this.propertiesViewer;
    }
}

