/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration;

import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class ReleaseUtils {
    private ReleaseUtils() {
    }

    public static String getNamespaceURI(URI uri) {
        return ReleaseUtils.getNamespaceURI_SAX(URIUtils.getJavaFile((URI)uri));
    }

    public static String getNamespaceURI_SAX(File file) {
        ContentHandler contentHandler;
        block14: {
            contentHandler = new ContentHandler();
            InputStreamReader fileReader = null;
            try {
                try {
                    XMLReader reader = XMLReaderFactory.createXMLReader();
                    reader.setContentHandler(contentHandler);
                    fileReader = new FileReader(file);
                    reader.parse(new InputSource(fileReader));
                }
                catch (Exception exception) {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return contentHandler.getNsURI();
    }

    public static String getNamespaceURI_Registry(URI modelURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        PackageRegistry registry = new PackageRegistry(resourceSet.getPackageRegistry());
        resourceSet.setPackageRegistry((EPackage.Registry)registry);
        Resource resource = resourceSet.createResource(modelURI);
        try {
            resource.load(null);
        }
        catch (Exception exception) {}
        return registry.getNsURI();
    }

    private static class ContentHandler
    extends DefaultHandler {
        private String nsURI;

        private ContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"http://www.omg.org/XMI".equals(uri) && !"http://www.w3.org/2001/XMLSchema".equals(uri)) {
                this.nsURI = uri;
                throw new SAXException();
            }
        }

        public String getNsURI() {
            return this.nsURI;
        }
    }

    private static class PackageRegistry
    implements EPackage.Registry {
        private final EPackage.Registry delegate;
        private String nsURI;

        public PackageRegistry(EPackage.Registry delegate) {
            this.delegate = delegate;
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        public Set entrySet() {
            return this.delegate.entrySet();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public Object get(Object key) {
            return this.delegate.get(key);
        }

        public EFactory getEFactory(String nsURI) {
            return this.delegate.getEFactory(nsURI);
        }

        public EPackage getEPackage(String nsURI) {
            if (this.nsURI == null) {
                this.nsURI = nsURI;
            }
            return this.delegate.getEPackage(nsURI);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Set keySet() {
            return this.delegate.keySet();
        }

        public Object put(String key, Object value) {
            return this.delegate.put((Object)key, value);
        }

        public void putAll(Map t) {
            this.delegate.putAll(t);
        }

        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        public int size() {
            return this.delegate.size();
        }

        public Collection values() {
            return this.delegate.values();
        }

        public String getNsURI() {
            return this.nsURI;
        }
    }
}

