/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.common;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public final class URIUtils {
    private URIUtils() {
    }

    public static IFile getFile(URI uri) {
        String platformString = uri.toPlatformString(true);
        if (platformString != null) {
            Path path = new Path(platformString);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public static IFolder getFolder(URI uri) {
        Path path = new Path(uri.toPlatformString(true));
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
    }

    public static URI getURI(IResource file) {
        return URIUtils.getURI(file.getFullPath());
    }

    public static URI getURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public static URI getURI(String fileName) {
        return URIUtils.getURI(new File(fileName));
    }

    public static URI getURI(File file) {
        return URI.createFileURI((String)file.getAbsolutePath());
    }

    public static URL getURL(URI uri) {
        try {
            URL url = new URL(uri.toString());
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URI getURI(URL url) {
        return URI.createURI((String)url.toString());
    }

    public static IFile replaceExtension(IFile file, String ext) {
        IProject project = file.getProject();
        return project.getFile(file.getProjectRelativePath().removeFileExtension().addFileExtension(ext));
    }

    public static URI replaceExtension(URI uri, String ext) {
        return uri.trimFileExtension().appendFileExtension(ext);
    }

    public static File getJavaFile(URI uri) {
        if (uri.isPlatform()) {
            IFile file = URIUtils.getFile(uri);
            IPath location = file.getLocation();
            return location.toFile();
        }
        return new File(uri.toFileString());
    }

    public static URI getRelativePath(URI uri, URI relativeTo) {
        return uri.deresolve(relativeTo, true, true, true);
    }
}

