/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.core.internal.ECPEMFUtils;
import org.eclipse.emf.ecp.emfstore.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.PreferenceHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPExportHandlerHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelper;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerFactory;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ImportProjectHelper {
    private static final String FILE_EXTENSION = ExportImportDataUnits.ProjectSpace.getExtension();
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*" + FILE_EXTENSION + ")"};
    public static final String[] FILTER_EXTS = new String[]{"*" + FILE_EXTENSION};
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.ecp.exportProjectModelPath";

    private ImportProjectHelper() {
    }

    public static void importProject(Shell shell) {
        File file = ImportProjectHelper.getFile(shell);
        if (file == null) {
            return;
        }
        try {
            new ExportImportControllerExecutor(file, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportProjectSpaceController());
            PreferenceHelper.setPreference((String)EXPORT_MODEL_PATH, (String)file.getParent());
            List localProjects = ECPEMFUtils.getESWorkspaceProviderInstance().getWorkspace().getLocalProjects();
            ESLocalProject localProject = (ESLocalProject)localProjects.get(localProjects.size() - 1);
            ECPProperties properties = ECPUtil.createProperties();
            properties.addProperty("projectSpaceID", localProject.getLocalProjectId().getId());
            InputDialog id = new InputDialog(shell, "Project Name", "Enter the name for the imported project.", localProject.getProjectName(), new IInputValidator(){

                public String isValid(String newText) {
                    return ECPUtil.getECPProjectManager().getProject(newText) == null ? null : String.format("A project with the name %s already exists.", newText);
                }
            });
            int result = id.open();
            if (1 == result) {
                return;
            }
            String projectName = id.getValue();
            ECPUtil.getECPProjectManager().createProject(ECPUtil.getECPProviderRegistry().getProvider("org.eclipse.emf.ecp.emfstore.provider"), projectName, properties);
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
        catch (ECPProjectWithNameExistsException ex) {
            Activator.log(ex);
        }
    }

    private static File getFile(Shell shell) {
        BundleContext bundleContext = FrameworkUtil.getBundle(ECPExportHandlerHelper.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ECPFileDialogHelper.class);
        ECPFileDialogHelper fileDialogHelper = (ECPFileDialogHelper)bundleContext.getService(serviceReference);
        String result = fileDialogHelper.getPathForImport(shell);
        bundleContext.ungetService(serviceReference);
        return new File(result);
    }
}

