/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.controlmapper;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.internal.core.services.controlmapper.SettingToControlExpandHelper;
import org.eclipse.emfforms.spi.core.services.controlmapper.EMFFormsSettingToControlMapper;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ViewModelListener
implements ModelChangeListener {
    private boolean isDisposed = false;
    private final EMFFormsStructuralChangeTester structuralChangeTester;
    private final ServiceReference<EMFFormsStructuralChangeTester> structuralChangeTesterServiceReference;
    private final EMFFormsViewContext viewModelContext;
    private final EMFFormsSettingToControlMapper settingToControlMapper;
    private final Set<VControl> vControls = new LinkedHashSet<VControl>();

    public ViewModelListener(EMFFormsViewContext context, EMFFormsSettingToControlMapper mapper) {
        this.viewModelContext = context;
        this.settingToControlMapper = mapper;
        BundleContext bundleContext = FrameworkUtil.getBundle(ViewModelListener.class).getBundleContext();
        this.structuralChangeTesterServiceReference = bundleContext.getServiceReference(EMFFormsStructuralChangeTester.class);
        this.structuralChangeTester = (EMFFormsStructuralChangeTester)bundleContext.getService(this.structuralChangeTesterServiceReference);
        TreeIterator eAllContents = this.viewModelContext.getViewModel().eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (!VControl.class.isInstance(eObject)) continue;
            VControl vControl = (VControl)VControl.class.cast(eObject);
            this.vControls.add(vControl);
        }
        this.viewModelContext.registerDomainChangeListener(this);
    }

    public void notifyChange(ModelChangeNotification notification) {
        for (VControl control : this.vControls) {
            VDomainModelReference reference = control.getDomainModelReference();
            if (reference == null || !this.structuralChangeTester.isStructureChanged(reference, this.viewModelContext.getDomainModel(), notification)) continue;
            SettingToControlExpandHelper.resolveDomainReferences((EObject)control, this.viewModelContext.getDomainModel(), this.viewModelContext);
            this.settingToControlMapper.updateControlMapping(control);
            if (!notification.getStructuralFeature().isMany()) {
                control.setDiagnostic(null);
            } else if (control.getDiagnostic() != null) {
                List diagnostics = control.getDiagnostic().getDiagnostic(notification.getNotifier(), notification.getStructuralFeature());
                control.getDiagnostic().getDiagnostics().removeAll((Collection)diagnostics);
            }
            for (DomainModelReferenceChangeListener listener : reference.getChangeListener()) {
                listener.notifyChange();
            }
        }
    }

    public boolean addVControl(VControl control) {
        return this.vControls.add(control);
    }

    public boolean removeVControl(VControl control) {
        return this.vControls.remove(control);
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.viewModelContext.unregisterDomainChangeListener(this);
        this.vControls.clear();
        BundleContext bundleContext = FrameworkUtil.getBundle(ViewModelListener.class).getBundleContext();
        bundleContext.ungetService(this.structuralChangeTesterServiceReference);
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

