/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractSWTRenderer<VELEMENT extends VElement>
extends AbstractRenderer<VELEMENT> {
    protected static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    private ModelChangeListener listener;
    private Map<SWTGridCell, Control> controls;
    private boolean renderingFinished;

    public AbstractSWTRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    public abstract SWTGridDescription getGridDescription(SWTGridDescription var1);

    public final void init() {
        this.preInit();
        this.controls = new LinkedHashMap<SWTGridCell, Control>();
        if (this.getViewModelContext() != null) {
            this.listener = new ModelChangeListener(){

                public void notifyChange(ModelChangeNotification notification) {
                    if (!AbstractSWTRenderer.this.renderingFinished) {
                        return;
                    }
                    if (notification.getRawNotification().isTouch()) {
                        return;
                    }
                    if (notification.getNotifier() != AbstractSWTRenderer.this.getVElement()) {
                        return;
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Visible()) {
                        AbstractSWTRenderer.this.applyVisible();
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Enabled() && !AbstractSWTRenderer.this.getVElement().isReadonly()) {
                        AbstractSWTRenderer.this.applyEnable();
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic()) {
                        AbstractSWTRenderer.this.applyValidation();
                    }
                }
            };
            this.getViewModelContext().registerViewChangeListener(this.listener);
        }
        this.getViewModelContext().addContextUser((Object)this);
        this.postInit();
    }

    protected final Map<SWTGridCell, Control> getControls() {
        if (this.controls == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<SWTGridCell, Control>(this.controls);
    }

    protected void preInit() {
    }

    protected void postInit() {
    }

    protected void dispose() {
        if (this.getViewModelContext() != null) {
            this.getViewModelContext().unregisterViewChangeListener(this.listener);
        }
        this.listener = null;
        this.controls = null;
        this.getViewModelContext().removeContextUser((Object)this);
        super.dispose();
    }

    public Control render(final SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Control control = this.controls.get((Object)cell);
        if (control != null) {
            return control;
        }
        control = this.renderControl(cell, parent);
        if (control == null) {
            return null;
        }
        this.controls.put(cell, control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractSWTRenderer.this.controls != null) {
                    AbstractSWTRenderer.this.controls.remove((Object)cell);
                }
            }
        });
        return control;
    }

    public void finalizeRendering(Composite parent) {
        if (this.renderingFinished) {
            return;
        }
        this.renderingFinished = true;
        this.applyVisible();
        this.applyReadOnly();
        if (!this.getVElement().isReadonly()) {
            this.applyEnable();
        }
        this.applyValidation();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractSWTRenderer.this.dispose();
            }
        });
    }

    protected abstract Control renderControl(SWTGridCell var1, Composite var2) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption;

    protected void applyReadOnly() {
        for (SWTGridCell gridCell : this.controls.keySet()) {
            this.setControlEnabled(gridCell, this.controls.get((Object)gridCell), !this.getVElement().isReadonly());
        }
    }

    protected void applyEnable() {
        for (SWTGridCell gridCell : this.controls.keySet()) {
            this.setControlEnabled(gridCell, this.controls.get((Object)gridCell), this.getVElement().isEnabled());
        }
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        control.setEnabled(enabled);
    }

    protected void applyVisible() {
        boolean visible = this.getVElement().isVisible();
        for (SWTGridCell gridCell : this.controls.keySet()) {
            GridData gridData;
            Object layoutData = this.controls.get((Object)gridCell).getLayoutData();
            if (GridData.class.isInstance(layoutData) && (gridData = (GridData)layoutData) != null) {
                gridData.exclude = !visible;
            }
            this.controls.get((Object)gridCell).setVisible(visible);
            this.controls.get((Object)gridCell).getParent().layout(false);
        }
    }

    protected void applyValidation() {
    }

    protected String getDefaultFontName(Control control) {
        return control.getDisplay().getSystemFont().getFontData()[0].getName();
    }
}

