/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.EnumComboViewerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public class EnumComboViewerSWTRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        EStructuralFeature eStructuralFeature = (EStructuralFeature)EStructuralFeature.class.cast(valueProperty.getValueType());
        if (eStructuralFeature.isMany()) {
            return Double.NaN;
        }
        if (!EAttribute.class.isInstance(eStructuralFeature)) {
            return Double.NaN;
        }
        EAttribute eAttribute = (EAttribute)EAttribute.class.cast(eStructuralFeature);
        if (!EcorePackage.eINSTANCE.getEEnum().isInstance((Object)eAttribute.getEType())) {
            return Double.NaN;
        }
        return 3.0;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return EnumComboViewerSWTRenderer.class;
    }
}

