/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.layout;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutOptimizer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EMFFormsSWTLayoutDelayed
implements EMFFormsSWTLayoutOptimizer {
    private Set<Composite> requestedLayouts = new LinkedHashSet<Composite>();
    private Thread thread;
    private ReportService reportService;

    @Override
    public synchronized void layout(Composite parent) {
        this.getRequestedLayouts().add(parent);
        this.layoutDelayed();
    }

    private synchronized void layoutDelayed() {
        if (this.thread != null || this.getRequestedLayouts().isEmpty()) {
            return;
        }
        Display defaultDisplay = Display.getDefault();
        this.thread = new Thread(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Set<Composite> toLayout = this.exchangeRequestedLayouts();
            defaultDisplay.asyncExec(() -> {
                try {
                    try {
                        for (Composite composite : toLayout) {
                            if (composite.isDisposed()) continue;
                            composite.layout(true, true);
                        }
                    }
                    catch (Exception ex) {
                        this.getReportService().report(new AbstractReport((Throwable)ex, "An exception occurred during re-layouting"));
                        this.thread = null;
                        this.layoutDelayed();
                    }
                }
                finally {
                    this.thread = null;
                    this.layoutDelayed();
                }
            });
        });
        this.thread.start();
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            Bundle bundle = FrameworkUtil.getBundle(EMFFormsSWTLayoutDelayed.class);
            if (bundle == null) {
                return null;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                return null;
            }
            ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
            this.reportService = (ReportService)bundleContext.getService(serviceReference);
        }
        return this.reportService;
    }

    private synchronized Set<Composite> getRequestedLayouts() {
        return this.requestedLayouts;
    }

    private synchronized void setRequestedLayouts(Set<Composite> requestedLayouts) {
        this.requestedLayouts = requestedLayouts;
    }

    private synchronized Set<Composite> exchangeRequestedLayouts() {
        LinkedHashSet<Composite> toLayout = new LinkedHashSet<Composite>(this.getRequestedLayouts());
        this.setRequestedLayouts(new LinkedHashSet<Composite>());
        return toLayout;
    }
}

