/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.style.unsettable.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ButtonPlacementType implements Enumerator
{
    RIGHT_OF_LABEL(0, "RIGHT_OF_LABEL", "RIGHT_OF_LABEL"),
    LEFT_OF_LABEL(1, "LEFT_OF_LABEL", "LEFT_OF_LABEL");

    public static final int RIGHT_OF_LABEL_VALUE = 0;
    public static final int LEFT_OF_LABEL_VALUE = 1;
    private static final ButtonPlacementType[] VALUES_ARRAY;
    public static final List<ButtonPlacementType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ButtonPlacementType[]{RIGHT_OF_LABEL, LEFT_OF_LABEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ButtonPlacementType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ButtonPlacementType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ButtonPlacementType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ButtonPlacementType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ButtonPlacementType get(int value) {
        switch (value) {
            case 0: {
                return RIGHT_OF_LABEL;
            }
            case 1: {
                return LEFT_OF_LABEL;
            }
        }
        return null;
    }

    private ButtonPlacementType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

