/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.celleditor.rcp;

import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class NativeWidgetHelper {
    private static final String WS_CARBON = "carbon";
    private static final String WS_COCOA = "cocoa";
    private static final String CHECKED_DEFAULT = "icons/checked.png";
    private static final String UNCHECKED_DEFAULT = "icons/unchecked.png";
    private static ServiceReference<ImageRegistryService> imageRegistryServiceReference;
    private static ImageData checked;
    private static ImageData unchecked;

    private NativeWidgetHelper() {
    }

    public static void initCheckBoxImages(Control control) {
        NativeWidgetHelper.createCheckBoxImage(control, true);
        NativeWidgetHelper.createCheckBoxImage(control, false);
    }

    public static Image getCheckBoxImage(Control control, CheckBoxState state) {
        switch (state) {
            case checked: {
                if (checked != null) {
                    return new Image((Device)control.getDisplay(), checked);
                }
                return NativeWidgetHelper.getImage(CHECKED_DEFAULT);
            }
            case unchecked: {
                if (unchecked != null) {
                    return new Image((Device)control.getDisplay(), unchecked);
                }
                return NativeWidgetHelper.getImage(UNCHECKED_DEFAULT);
            }
        }
        return null;
    }

    private static void createCheckBoxImage(Control control, boolean type) {
        Point bsize;
        Color greenScreen = new Color((Device)control.getDisplay(), 222, 223, 224);
        Shell shell = new Shell(control.getShell(), 8);
        shell.setBackground(greenScreen);
        if (NativeWidgetHelper.isMac()) {
            Button button2 = new Button((Composite)shell, 32);
            bsize = button2.computeSize(-1, -1);
            bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
            bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
            button2.setSize(bsize);
            button2.setLocation(100, 100);
        }
        Button button = new Button((Composite)shell, 32);
        button.setBackground(greenScreen);
        button.setSelection(type);
        button.setLocation(1, 1);
        bsize = button.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        button.setSize(bsize);
        shell.setSize(bsize);
        shell.setVisible(false);
        shell.open();
        GC gc = new GC((Drawable)shell);
        Image image = new Image((Device)control.getDisplay(), bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        shell.close();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        if (type) {
            checked = imageData;
        } else {
            unchecked = imageData;
        }
        image.dispose();
    }

    private static boolean isMac() {
        String ws = SWT.getPlatform();
        return WS_CARBON.equals(ws) || WS_COCOA.equals(ws);
    }

    private static Image getImage(String path) {
        Bundle bundle = FrameworkUtil.getBundle(NativeWidgetHelper.class);
        Image image = NativeWidgetHelper.getImageRegistryService().getImage(bundle, path);
        bundle.getBundleContext().ungetService(imageRegistryServiceReference);
        return image;
    }

    private static ImageRegistryService getImageRegistryService() {
        Bundle bundle = FrameworkUtil.getBundle(NativeWidgetHelper.class);
        if (imageRegistryServiceReference == null) {
            imageRegistryServiceReference = bundle.getBundleContext().getServiceReference(ImageRegistryService.class);
        }
        return (ImageRegistryService)bundle.getBundleContext().getService(imageRegistryServiceReference);
    }

    public static enum CheckBoxState {
        checked,
        unchecked;

    }
}

