/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VReadOnlyColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VWidthConfiguration;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.widgets.Widget;

public final class TableConfigurationHelper {
    private static final String LAYOUT_DATA = "org.eclipse.jface.LAYOUT_DATA";

    private TableConfigurationHelper() {
    }

    public static boolean isReadOnly(VTableControl tableControl, VDomainModelReference domainModelReference) {
        boolean readOnly = false;
        for (VTableColumnConfiguration columnConfiguration : tableControl.getColumnConfigurations()) {
            if (!VReadOnlyColumnConfiguration.class.isInstance(columnConfiguration)) continue;
            VReadOnlyColumnConfiguration configuration = (VReadOnlyColumnConfiguration)VReadOnlyColumnConfiguration.class.cast(columnConfiguration);
            return configuration.getColumnDomainReferences().contains((Object)domainModelReference);
        }
        return false;
    }

    public static Optional<Integer> getColumnWidth(VTableControl tableControl, VDomainModelReference domainModelReference) {
        for (VTableColumnConfiguration configuration : tableControl.getColumnConfigurations()) {
            VWidthConfiguration widthConfiguration;
            if (!VWidthConfiguration.class.isInstance(configuration) || (widthConfiguration = (VWidthConfiguration)VWidthConfiguration.class.cast(configuration)).getColumnDomainReference() != domainModelReference) continue;
            return Optional.ofNullable((Object)widthConfiguration.getMinWidth());
        }
        return Optional.empty();
    }

    public static Optional<Integer> getColumnWeight(VTableControl tableControl, VDomainModelReference domainModelReference) {
        for (VTableColumnConfiguration configuration : tableControl.getColumnConfigurations()) {
            VWidthConfiguration widthConfiguration;
            if (!VWidthConfiguration.class.isInstance(configuration) || (widthConfiguration = (VWidthConfiguration)VWidthConfiguration.class.cast(configuration)).getColumnDomainReference() != domainModelReference) continue;
            return Optional.ofNullable((Object)widthConfiguration.getWeight());
        }
        return Optional.empty();
    }

    public static void updateWidthConfiguration(VTableControl tableControl, VDomainModelReference domainModelReference, Widget tableColumn) {
        Object layoutData = tableColumn.getData(LAYOUT_DATA);
        if (!ColumnPixelData.class.isInstance(layoutData) && !ColumnWeightData.class.isInstance(layoutData)) {
            return;
        }
        VWidthConfiguration widthConfiguration = null;
        for (VTableColumnConfiguration configuration : tableControl.getColumnConfigurations()) {
            VWidthConfiguration candidate;
            if (!VWidthConfiguration.class.isInstance(configuration) || (candidate = (VWidthConfiguration)VWidthConfiguration.class.cast(configuration)).getColumnDomainReference() != domainModelReference) continue;
            widthConfiguration = candidate;
            break;
        }
        if (widthConfiguration == null) {
            widthConfiguration = VTableFactory.eINSTANCE.createWidthConfiguration();
            widthConfiguration.setColumnDomainReference(domainModelReference);
            tableControl.getColumnConfigurations().add((Object)widthConfiguration);
        }
        if (ColumnPixelData.class.isInstance(layoutData)) {
            ColumnPixelData columnPixelData = (ColumnPixelData)ColumnPixelData.class.cast(layoutData);
            widthConfiguration.setMinWidth(columnPixelData.width);
            widthConfiguration.setWeight(-1);
        } else {
            ColumnWeightData columnWeightData = (ColumnWeightData)ColumnWeightData.class.cast(layoutData);
            widthConfiguration.setMinWidth(columnWeightData.minimumWidth);
            widthConfiguration.setWeight(columnWeightData.weight);
        }
    }
}

