/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.wizard;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecoretools.design.EcoreToolsViewpoints;
import org.eclipse.emf.ecoretools.design.ui.wizard.pages.SelectAirdWizardPage;
import org.eclipse.emf.ecoretools.design.ui.wizard.pages.SelectRepresentationDescriptionWizardPage;
import org.eclipse.emf.ecoretools.design.ui.wizard.pages.SelectRootSemanticElementWizardPage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.EditingSessionEvent;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class InitializeEcoreDiagramWizard
extends Wizard {
    private SelectAirdWizardPage airdFilePage;
    private IProject containingProject;
    private DRepresentation createdDRepresentation;
    private Collection<URI> domainModelURI;
    private Session existingSession = null;
    private SelectRepresentationDescriptionWizardPage representationWizardPage;
    private SelectRootSemanticElementWizardPage selectElementPage;
    private IStructuredSelection selection;

    public InitializeEcoreDiagramWizard(IStructuredSelection selection, Collection<URI> domainModelURI, IProject containingProject) {
        this.selection = selection;
        this.domainModelURI = domainModelURI;
        this.containingProject = containingProject;
    }

    public void addPages() {
        boolean userMightSelectAird;
        this.airdFilePage = new SelectAirdWizardPage("DiagramModelFile", this.selection, "aird");
        this.airdFilePage.setDescription("Pick an .aird file which will store the diagram, tree, or tables related data.");
        Option prj = ModelingProject.asModelingProject((IProject)this.containingProject);
        boolean bl = userMightSelectAird = !prj.some();
        if (userMightSelectAird) {
            this.addPage((IWizardPage)this.airdFilePage);
        }
        Supplier<Session> sSupplier = new Supplier<Session>(){

            public Session get() {
                if (InitializeEcoreDiagramWizard.this.existingSession == null) {
                    Option prj;
                    for (Session session : SessionManager.INSTANCE.getSessions()) {
                        ResourceSet set = session.getTransactionalEditingDomain().getResourceSet();
                        for (Resource res : set.getResources()) {
                            if (res.getURI() == null) continue;
                            for (URI uri : InitializeEcoreDiagramWizard.this.domainModelURI) {
                                if (!set.getURIConverter().normalize(res.getURI()).equals(set.getURIConverter().normalize(uri))) continue;
                                InitializeEcoreDiagramWizard.this.existingSession = session;
                            }
                        }
                    }
                    if (InitializeEcoreDiagramWizard.this.existingSession == null && (prj = ModelingProject.asModelingProject((IProject)InitializeEcoreDiagramWizard.this.containingProject)).some()) {
                        Option optionalMainSessionFileURI2;
                        InitializeEcoreDiagramWizard.this.existingSession = ((ModelingProject)prj.get()).getSession();
                        if (InitializeEcoreDiagramWizard.this.existingSession == null && (optionalMainSessionFileURI2 = ((ModelingProject)prj.get()).getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor(), false, false)).some()) {
                            ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile((URI)optionalMainSessionFileURI2.get());
                        }
                        if (OpenRepresentationsFileJob.shouldWaitOtherJobs()) {
                            try {
                                Job.getJobManager().join((Object)"org.eclipse.sirius.representationsFile", (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (InterruptedException optionalMainSessionFileURI2) {
                                // empty catch block
                            }
                        }
                        InitializeEcoreDiagramWizard.this.existingSession = ((ModelingProject)prj.get()).getSession();
                        if (InitializeEcoreDiagramWizard.this.existingSession != null) {
                            InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain()){

                                protected void doExecute() {
                                    for (URI uri : InitializeEcoreDiagramWizard.this.domainModelURI) {
                                        ((ModelingProject)prj.get()).getSession().addSemanticResource(uri, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                            });
                        }
                    }
                    if (InitializeEcoreDiagramWizard.this.existingSession == null || userMightSelectAird && InitializeEcoreDiagramWizard.this.pickedAnotherAird(InitializeEcoreDiagramWizard.this.existingSession)) {
                        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(InitializeEcoreDiagramWizard.this.airdFilePage.getURI(), monitor);
                                sessionCreationOperation.execute();
                                InitializeEcoreDiagramWizard.this.existingSession = sessionCreationOperation.getCreatedSession();
                            }
                        };
                        try {
                            InitializeEcoreDiagramWizard.this.getContainer().run(false, true, (IRunnableWithProgress)op);
                        }
                        catch (InterruptedException optionalMainSessionFileURI2) {
                        }
                        catch (InvocationTargetException e) {
                            if (e.getTargetException() instanceof CoreException) {
                                ErrorDialog.openError((Shell)InitializeEcoreDiagramWizard.this.getContainer().getShell(), (String)Messages.CreateSessionResourceWizard_resourceCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
                            }
                            SiriusTransPlugin.getPlugin().error(Messages.CreateSessionResourceWizard_sessionDataCreationError, e.getTargetException());
                        }
                    }
                    if (InitializeEcoreDiagramWizard.this.existingSession != null) {
                        InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain()){

                            protected void doExecute() {
                                for (URI uri : InitializeEcoreDiagramWizard.this.domainModelURI) {
                                    InitializeEcoreDiagramWizard.this.existingSession.addSemanticResource(uri, (IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                        });
                        IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(InitializeEcoreDiagramWizard.this.existingSession);
                        uiSession.open();
                        InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain()){

                            protected void doExecute() {
                                Set fromEcoreTools = EcoreToolsViewpoints.fromViewpointRegistry().all();
                                ViewpointSelectionCallback selection = new ViewpointSelectionCallback();
                                for (Viewpoint previouslySelected : InitializeEcoreDiagramWizard.this.existingSession.getSelectedViewpoints(false)) {
                                    if (!fromEcoreTools.contains(previouslySelected)) continue;
                                    selection.deselectViewpoint(previouslySelected, InitializeEcoreDiagramWizard.this.existingSession, (IProgressMonitor)new NullProgressMonitor());
                                }
                                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().design(), InitializeEcoreDiagramWizard.this.existingSession, new NullProgressMonitor());
                                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().review(), InitializeEcoreDiagramWizard.this.existingSession, new NullProgressMonitor());
                                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().archetype(), InitializeEcoreDiagramWizard.this.existingSession, new NullProgressMonitor());
                                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().generation(), InitializeEcoreDiagramWizard.this.existingSession, new NullProgressMonitor());
                            }

                            private void selectViewpoint(ViewpointSelectionCallback selection, Viewpoint vp, Session session, NullProgressMonitor progressMonitor) {
                                if (vp != null) {
                                    selection.selectViewpoint(vp, session, (IProgressMonitor)progressMonitor);
                                }
                            }
                        });
                    }
                }
                return InitializeEcoreDiagramWizard.this.existingSession;
            }
        };
        this.representationWizardPage = new SelectRepresentationDescriptionWizardPage(sSupplier, Sets.newHashSet((Object[])new String[]{"Entities"}));
        this.selectElementPage = new SelectRootSemanticElementWizardPage(sSupplier, this.representationWizardPage);
        this.addPage((IWizardPage)this.representationWizardPage);
        this.addPage((IWizardPage)this.selectElementPage);
    }

    private boolean pickedAnotherAird(Session existingSession) {
        if (existingSession.getSessionResource() != null) {
            URI sessURI = existingSession.getSessionResource().getURI();
            URIConverter conv = existingSession.getTransactionalEditingDomain().getResourceSet().getURIConverter();
            if (sessURI != null && conv != null) {
                return !conv.normalize(this.airdFilePage.getURI()).equals(conv.normalize(sessURI));
            }
        }
        return true;
    }

    public boolean canFinish() {
        if (this.existingSession != null && this.representationWizardPage.get() != null && this.selectElementPage.getSelectedElement() != null) {
            return true;
        }
        return super.canFinish();
    }

    public void dispose() {
        super.dispose();
        this.selectElementPage.dispose();
        this.representationWizardPage.dispose();
        this.airdFilePage.dispose();
    }

    public void init() {
        this.setWindowTitle("Create Representation");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        EObject element = this.selectElementPage.getSelectedElement();
        if (element != null && this.representationWizardPage.get() != null) {
            try {
                final String representationName = this.selectElementPage.get();
                IRunnableWithProgress representationCreationRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(Messages.CreateRepresentationAction_creationTask, 5);
                            CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(InitializeEcoreDiagramWizard.this.existingSession, InitializeEcoreDiagramWizard.this.representationWizardPage.get(), InitializeEcoreDiagramWizard.this.selectElementPage.getSelectedElement(), representationName, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(InitializeEcoreDiagramWizard.this.existingSession);
                            editingSession.notify(EditingSessionEvent.REPRESENTATION_ABOUT_TO_BE_CREATED_BEFORE_OPENING);
                            InitializeEcoreDiagramWizard.this.existingSession.getTransactionalEditingDomain().getCommandStack().execute((Command)createRepresentationCommand);
                            editingSession.notify(EditingSessionEvent.REPRESENTATION_CREATED_BEFORE_OPENING);
                            InitializeEcoreDiagramWizard.this.createdDRepresentation = createRepresentationCommand.getCreatedRepresentation();
                            monitor.worked(1);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                this.getContainer().run(true, false, representationCreationRunnable);
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.CreateRepresentationAction_openingTask, 1);
                            DialectUIManager.INSTANCE.openEditor(InitializeEcoreDiagramWizard.this.existingSession, InitializeEcoreDiagramWizard.this.createdDRepresentation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, null);
            }
            catch (InvocationTargetException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
            }
            catch (InterruptedException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return true;
    }
}

