/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSessionsDialog
extends ListSelectionDialog {
    private String description;
    private Text textdescr;

    public MergeSessionsDialog(Shell parent, List<ICoverageSession> sessions, String description) {
        super(parent, sessions, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new WorkbenchLabelProvider(), UIMessages.MergeSessionsDialogSelection_label);
        this.setTitle(UIMessages.MergeSessionsDialog_title);
        this.setInitialSelections(sessions.toArray());
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<ICoverageSession> getSessions() {
        ArrayList<ICoverageSession> sessions = new ArrayList<ICoverageSession>();
        Object[] objectArray = this.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            sessions.add((ICoverageSession)s);
            ++n2;
        }
        return sessions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        ContextHelp.setHelp((Control)shell, "org.eclipse.eclemma.ui.merge_sessions_context");
    }

    protected Label createMessageArea(Composite composite) {
        Label l = new Label(composite, 0);
        l.setFont(composite.getFont());
        l.setText(UIMessages.MergeSessionsDialogDescription_label);
        this.textdescr = new Text(composite, 2048);
        this.textdescr.setFont(composite.getFont());
        this.textdescr.setLayoutData((Object)new GridData(768));
        this.textdescr.setText(this.description);
        this.textdescr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        return super.createMessageArea(composite);
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        Button b1 = this.getButton(18);
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        Button b2 = this.getButton(19);
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        return c;
    }

    protected void okPressed() {
        this.description = this.textdescr.getText().trim();
        super.okPressed();
    }

    private void updateButtonsEnableState() {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(this.getViewer().getCheckedElements().length > 1 && this.textdescr.getText().trim().length() > 0);
        }
    }
}

