/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.ui.tools.AbstractVirtualTreeProvider;

public class VariablesTreeContentProvider
extends AbstractVirtualTreeProvider {
    private final Collection<IPath> fAdditionalPaths = new HashSet<IPath>();

    protected void populateElements(Object inputElement) {
        if (inputElement instanceof List) {
            List elements = (List)inputElement;
            for (Object convertedInputElement : elements) {
                if (!(convertedInputElement instanceof TestSuiteModel.Variable)) continue;
                TestSuiteModel.Variable variable = (TestSuiteModel.Variable)convertedInputElement;
                IPath path = variable.getPath();
                this.registerElement(path, convertedInputElement);
            }
        }
        this.setShowRoot(false);
        for (IPath additionalPath : this.fAdditionalPaths) {
            this.registerPath(additionalPath.makeAbsolute());
        }
    }

    public void addPath(IPath path) {
        this.fAdditionalPaths.add(path);
        this.registerPath(path);
    }

    public void removePath(IPath path) {
        this.fAdditionalPaths.remove(path);
    }

    public static IPath buildPath(IPath sourcePath, IPath targetPath, int count) {
        sourcePath = sourcePath.removeFirstSegments(count);
        return targetPath.append(sourcePath);
    }

    public void removeMatchingPaths(IPath pathPrefix) {
        for (IPath currentPath : new HashSet<IPath>(this.fAdditionalPaths)) {
            if (!pathPrefix.isPrefixOf(currentPath)) continue;
            this.removePath(currentPath);
        }
    }

    public void exchangePrefixPaths(IPath pathPrefix, String newValue) {
        for (IPath currentPath : new HashSet<IPath>(this.fAdditionalPaths)) {
            if (!pathPrefix.isPrefixOf(currentPath)) continue;
            this.removePath(currentPath);
            IPath newPath = pathPrefix.removeLastSegments(1);
            newPath = newPath.append(newValue);
            int count = pathPrefix.segmentCount();
            this.addPath(VariablesTreeContentProvider.buildPath(currentPath, newPath, count));
        }
    }

    public void moveSelectedPath(IPath parentTargetDrop, IPath selection) {
        int segmentsPath = selection.segmentCount();
        for (IPath currentPath : new HashSet<IPath>(this.fAdditionalPaths)) {
            if (!currentPath.uptoSegment(segmentsPath).equals((Object)selection)) continue;
            IPath oldPath = currentPath;
            int count = selection.segmentCount();
            this.addPath(VariablesTreeContentProvider.buildPath(oldPath, parentTargetDrop, count));
        }
        this.removeMatchingPaths(selection);
    }

    public void updateVariablesForRenamedNode(List<TestSuiteModel.Variable> variables, IPath node, String newValue) {
        ArrayList<TestSuiteModel.Variable> variablesRenamed = new ArrayList<TestSuiteModel.Variable>();
        for (TestSuiteModel.Variable variable : variables) {
            if (!variable.getPath().uptoSegment(node.segmentCount()).equals((Object)node.makeAbsolute())) continue;
            variablesRenamed.add(variable);
        }
        for (TestSuiteModel.Variable currentVariable : variablesRenamed) {
            IPath newPath = node.removeLastSegments(1);
            newPath = newPath.append(newValue);
            int count = node.segmentCount();
            currentVariable.setPath(VariablesTreeContentProvider.buildPath(currentVariable.getPath(), newPath, count));
        }
    }

    public static void updatePathGroup(List<TestSuiteModel.Variable> variables, IPath node, IPath selection) {
        int segmentsSelection = selection.segmentCount();
        for (TestSuiteModel.Variable variable : variables) {
            if (!variable.getPath().uptoSegment(segmentsSelection).equals((Object)selection.makeAbsolute())) continue;
            IPath oldPath = variable.getPath();
            int count = selection.segmentCount();
            variable.setPath(VariablesTreeContentProvider.buildPath(oldPath, node, count));
        }
    }
}

