/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.help.hovers.JavaClassHelpResolver;
import org.eclipse.ease.ui.help.hovers.JavaFieldHelpResolver;
import org.eclipse.ease.ui.help.hovers.JavaMethodHelpResolver;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;

public class JavaMethodCompletionProvider
extends AbstractCompletionProvider {
    @Override
    public boolean isActive(ICompletionContext context) {
        return context.getReferredClazz() != null;
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        StyledString styledString;
        JavaClassHelpResolver helpResolver;
        Class clazz = context.getReferredClazz();
        AccessibleObject[] accessibleObjectArray = clazz.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            if ((context.getType() != ICompletionContext.Type.STATIC_CLASS || Modifier.isStatic(method.getModifiers())) && this.matchesFilterIgnoreCase(method.getName())) {
                helpResolver = new JavaMethodHelpResolver(method);
                styledString = new StyledString(String.valueOf(method.getName()) + "(" + JavaMethodCompletionProvider.getMethodSignature(method) + ") : " + JavaMethodCompletionProvider.getMethodReturnType(method));
                styledString.append(" - " + method.getDeclaringClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                if (method.getParameterTypes().length > 0) {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "(", JavaMethodCompletionProvider.getMethodImage(Modifier.isStatic(method.getModifiers())), 40, (IHelpResolver)helpResolver);
                } else {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "()", JavaMethodCompletionProvider.getMethodImage(Modifier.isStatic(method.getModifiers())), 40, (IHelpResolver)helpResolver);
                }
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            if ((context.getType() != ICompletionContext.Type.STATIC_CLASS || Modifier.isStatic(((Field)field).getModifiers())) && this.matchesFilterIgnoreCase(((Field)field).getName())) {
                helpResolver = new JavaFieldHelpResolver((Field)field);
                styledString = new StyledString(String.valueOf(((Field)field).getName()) + " : " + ((Field)field).getType().getSimpleName());
                styledString.append(" - " + ((Field)field).getDeclaringClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                this.addProposal(styledString, ((Field)field).getName(), JavaMethodCompletionProvider.getFieldImage(Modifier.isStatic(((Field)field).getModifiers())), 20, (IHelpResolver)helpResolver);
            }
            ++n2;
        }
    }

    private static ImageDescriptor getMethodImage(boolean isStatic) {
        if (isStatic) {
            return Activator.getImageDescriptor("org.eclipse.ease.ui", "/icons/eobj16/static_function.png");
        }
        return JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.methpub_obj.gif");
    }

    private static ImageDescriptor getFieldImage(boolean isStatic) {
        if (isStatic) {
            return Activator.getImageDescriptor("org.eclipse.ease.ui", "/icons/eobj16/static_field.png");
        }
        return JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.field_public_obj.gif");
    }

    public static String getMethodReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType != null ? returnType.getSimpleName() : "void";
    }

    public static String getMethodSignature(Method method) {
        StringBuilder result = new StringBuilder();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(type.getSimpleName());
            ++n2;
        }
        return result.toString();
    }

    public static ImageDescriptor getSharedImage(String name) {
        return JavaUI.getSharedImages().getImageDescriptor(name);
    }
}

