/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.ui.views.UnitTestView;
import org.eclipse.ease.ui.tools.ToggleHandler;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleTestFilter
extends ToggleHandler {
    protected void executeToggle(ExecutionEvent event, boolean checked) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof UnitTestView) {
            if (checked) {
                ViewerFilter[] filter = new ViewerFilter[]{new Filter()};
                ((UnitTestView)part).getFileTreeViewer().setFilters(filter);
                ((UnitTestView)part).getTableViewer().setFilters(filter);
            } else {
                ((UnitTestView)part).getFileTreeViewer().setFilters(new ViewerFilter[0]);
                ((UnitTestView)part).getTableViewer().setFilters(new ViewerFilter[0]);
            }
        }
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TestEntity) {
                TestStatus status = ((TestEntity)element).getStatus();
                return status != TestStatus.PASS;
            }
            return true;
        }

        public boolean isFilterProperty(Object element, String property) {
            return "test status".equals(property);
        }
    }
}

