/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.EmptyResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.ResultResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandlerFactory;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.RequestUtils;

public class DebugMessageProcessor {
    private static final Gson GSON = new Gson();

    public synchronized void processMessage(String message, Session session) throws IOException {
        if (RequestUtils.isInspectorEnable((String)message)) {
            this.sendInitialConfiguration(session);
            return;
        }
        if (this.receivedInspectorEnable(session)) {
            this.handle(message, session);
        }
    }

    private void sendInitialConfiguration(Session session) throws IOException {
        Integer sweId = this.sendServiceWorkerEnable(session);
        Integer cenId = this.sendCanEmulateNetwork(session);
        Integer ieId = this.sendInspectorEnable(session);
        List receivedMessages = MessageDispatcher.receivedMessages((String)session.getId());
        if (receivedMessages != null) {
            for (String message : receivedMessages) {
                if (!this.shouldProcessMessage(message, sweId, cenId, ieId)) continue;
                this.handle(message, session);
            }
        }
    }

    private Integer sendServiceWorkerEnable(Session session) {
        Integer messageId = MessageDispatcher.getMessageIdForMessageMethod((String)session.getId(), (String)"ServiceWorker.enable");
        EmptyResponse response = new EmptyResponse(messageId);
        MessageDispatcher.sendMessage((String)GSON.toJson((Object)response), (Session)session);
        return messageId;
    }

    private Integer sendCanEmulateNetwork(Session session) {
        Integer messageId = MessageDispatcher.getMessageIdForMessageMethod((String)session.getId(), (String)"Network.canEmulateNetworkConditions");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("result", false);
        ResultResponse response = new ResultResponse(messageId, result);
        MessageDispatcher.sendMessage((String)GSON.toJson((Object)response), (Session)session);
        return messageId;
    }

    private Integer sendInspectorEnable(Session session) {
        Integer messageId = MessageDispatcher.getMessageIdForMessageMethod((String)session.getId(), (String)"Inspector.enable");
        EmptyResponse response = new EmptyResponse(messageId);
        MessageDispatcher.sendMessage((String)GSON.toJson((Object)response), (Session)session);
        return messageId;
    }

    private boolean shouldProcessMessage(String message, Integer sweId, Integer cenId, Integer ieId) {
        Integer messageId = RequestUtils.getMessageId((String)message);
        return !messageId.equals(sweId) && !messageId.equals(cenId) && !messageId.equals(ieId);
    }

    private void handle(String message, Session session) throws IOException {
        MessageHandler handler = MessageHandlerFactory.getHandler((String)message);
        handler.handle(message, session);
    }

    private boolean receivedInspectorEnable(Session session) {
        return MessageDispatcher.sessionHistoryContains((String)session.getId(), (String)"Inspector.enable");
    }
}

