/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.job;

import java.util.List;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.job.JobsUpdater;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public class JobsSynchronizer
implements Runnable {
    private static final Logger logger = Logger.getLogger(JobsSynchronizer.class);

    @Override
    public void run() {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "run");
        try {
            this.refreshJobs();
            logger.debug("Refresh of jobs locations successful for: " + JobsUpdater.activeJobs.size());
        }
        catch (Exception e) {
            logger.error("Refreshing Jobs failed.", (Throwable)e);
        }
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "run");
    }

    public static List<String> getActiveJobs() {
        return JobsUpdater.activeJobs;
    }

    private void refreshJobs() throws ServletException {
        try {
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(null);
            IRepository repository = RepositoryFacade.getInstance().getRepository(null);
            JobsUpdater jobsUpdater = new JobsUpdater(repository, dataSource, "/db/dirigible/registry/public/IntegrationServices");
            jobsUpdater.applyUpdates();
            jobsUpdater.cleanDeletedJobs();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

