/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.models;

import org.eclipse.dirigible.runtime.chrome.debugger.models.Location;

public class Breakpoint
implements Comparable<Breakpoint> {
    private String id;
    private Location location;

    public Breakpoint() {
    }

    public Breakpoint(String id, Location location) {
        this.id = id;
        this.location = location;
    }

    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(Breakpoint otherBreakpoint) {
        int idsCompared = this.id.compareTo(otherBreakpoint.id);
        if (idsCompared == 0) {
            Location otherLocation = otherBreakpoint.getLocation();
            return this.location.compareTo(otherLocation);
        }
        return idsCompared;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Breakpoint other = (Breakpoint)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return "Breakpoint [id=" + this.id + ", location=" + this.location + "]";
    }
}

