/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.view;

import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.repository.ui.view.IRefreshableView;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.ide.workspace.ui.view.Messages;
import org.eclipse.dirigible.ide.workspace.ui.view.ToolBarMenuViewProvider;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewer;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewerUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class WorkspaceExplorerView
extends ViewPart
implements IRefreshableView {
    public static final String VIEW_ID = "org.eclipse.dirigible.ide.workspace.ui.view.WorkspaceExplorerView";
    private static final String CHECK_LOGS_FOR_MORE_INFO = Messages.WorkspaceExplorerView_CHECK_LOGS_FOR_MORE_INFO;
    private static final String COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR = Messages.WorkspaceExplorerView_COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR;
    private static final String OPERATION_FAILED = Messages.WorkspaceExplorerView_OPERATION_FAILED;
    private static final String COULD_NOT_EXECUTE_OPEN_COMMAND = Messages.WorkspaceExplorerView_COULD_NOT_EXECUTE_OPEN_COMMAND;
    private static final Logger logger = Logger.getLogger(WorkspaceExplorerView.class);
    private static final String OPEN_COMMAND_ID = "org.eclipse.dirigible.ide.workspace.ui.commands.OpenHandler";
    private WorkspaceViewer viewer = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ToolBarMenuViewProvider.createToolBarMenu(parent, this.getSite().getShell());
        this.viewer = new WorkspaceViewer(parent, 2);
        this.viewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WorkspaceExplorerView.this.onWorkspaceViewerDoubleClicked(event);
            }
        });
        this.getSite().setSelectionProvider(this.viewer.getSelectionProvider());
        this.getSite().registerContextMenu("org.eclipse.dirigible.ide.workspace.ui.view.Menu", this.viewer.getMenuManager(), this.viewer.getSelectionProvider());
        this.setSelectedProjectFromRequest();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        AbstractWorkspaceHandler.attachSelectionListener((IWorkbenchPartSite)site);
    }

    public void dispose() {
        AbstractWorkspaceHandler.detachSelectionListener(this.getSite());
        super.dispose();
    }

    private void setSelectedProjectFromRequest() {
        try {
            String projectName = CommonParameters.get((String)"project");
            if (projectName != null) {
                ArrayList<Object> selected = new ArrayList<Object>();
                TreeItem[] treeItems = this.viewer.getViewer().getTree().getItems();
                int i = 0;
                while (i < treeItems.length) {
                    TreeItem treeItem = treeItems[i];
                    Object treeObject = treeItem.getData();
                    if (treeObject instanceof IProject && projectName.equals(((IProject)treeObject).getName())) {
                        selected.add(treeObject);
                        break;
                    }
                    ++i;
                }
                this.viewer.getViewer().setExpandedElements(selected.toArray(new Object[0]));
            }
        }
        catch (Exception exception) {}
    }

    private void onWorkspaceViewerDoubleClicked(DoubleClickEvent event) {
        ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Command command = commandService.getCommand(OPEN_COMMAND_ID);
        ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, null);
        try {
            command.executeWithChecks(executionEvent);
        }
        catch (Exception ex) {
            logger.error(COULD_NOT_EXECUTE_OPEN_COMMAND, (Throwable)ex);
            MessageDialog.openError(null, (String)OPERATION_FAILED, (String)(String.valueOf(COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR) + ex.getMessage() + CHECK_LOGS_FOR_MORE_INFO));
        }
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFolder || element instanceof IProject) {
                    WorkspaceViewerUtils.doubleClickedElement(element);
                }
                ++n2;
            }
        }
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public WorkspaceViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (IRefreshableView.class.equals((Object)adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected IWorkspace getWorkspace() {
        return WorkspaceLocator.getWorkspace();
    }
}

