/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class UploadHandler
extends AbstractHandler {
    private static final String DO_YOU_WANT_TO_OVERRIDE_IT = Messages.UploadHandler_DO_YOU_WANT_TO_OVERRIDE_IT;
    private static final String FILE_S_ALREADY_EXISTS = Messages.UploadHandler_FILE_S_ALREADY_EXISTS;
    private static final String UPLOAD_FILE = Messages.UploadHandler_UPLOAD_FILE;
    private static final String CANNOT_DELETE_FILE = Messages.UploadHandler_CANNOT_DELETE_FILE;
    private static final String CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE = Messages.UploadHandler_CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE;
    private static final String UPLOAD_ERROR = Messages.UploadHandler_UPLOAD_ERROR;
    private static final String REASON = Messages.UploadHandler_REASON;
    private static final String CANNOT_UPLOAD = Messages.UploadHandler_CANNOT_UPLOAD;
    private static final String CANNOT_SAVE_UPLOADED_FILE = Messages.UploadHandler_CANNOT_SAVE_UPLOADED_FILE;
    private static final Logger logger = Logger.getLogger(UploadHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dlg = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 34);
        dlg.setText(UPLOAD_FILE);
        dlg.open();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IFolder) {
            IFolder folder = (IFolder)firstElement;
            String fileName = null;
            String[] stringArray = dlg.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block19: {
                    String fullFileName = stringArray[n2];
                    fileName = fullFileName.substring(fullFileName.lastIndexOf(File.separatorChar) + 1);
                    IFile file = folder.getFile(fileName);
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(fullFileName);
                            if (file.exists()) {
                                boolean overrideIt = MessageDialog.openConfirm(null, (String)String.format(FILE_S_ALREADY_EXISTS, file.getName()), (String)DO_YOU_WANT_TO_OVERRIDE_IT);
                                if (overrideIt) {
                                    file.setContents((InputStream)in, 1, null);
                                }
                            } else {
                                file.create((InputStream)in, false, null);
                            }
                        }
                        catch (Exception e) {
                            logger.error(String.valueOf(CANNOT_SAVE_UPLOADED_FILE) + fileName, (Throwable)e);
                            MessageDialog.openError(null, (String)UPLOAD_ERROR, (String)(String.valueOf(CANNOT_UPLOAD) + fileName + REASON + e.getMessage()));
                            this.cleanUp(folder, fileName);
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException e2) {
                                    logger.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e2);
                                }
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e) {
                                logger.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            logger.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private void cleanUp(IFolder folder, String fileName) {
        IFile file = folder.getFile(fileName);
        try {
            file.delete(true, null);
        }
        catch (CoreException e) {
            logger.warn(CANNOT_DELETE_FILE, (Throwable)e);
        }
    }
}

