/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.info;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public abstract class JVMInfo {
    public static final int JDK_ID;
    public static final int J2SE_14 = 4;
    public static final int J2SE_142 = 5;
    public static final int J2SE_15 = 6;
    public static final int J2SE_16 = 7;
    public static final int J2SE_17 = 8;
    public static final boolean J2ME;

    private static boolean vmCheck(String string, String string2) {
        return string.equals(string2) || string.startsWith(string2 + "_");
    }

    public static String derbyVMLevel() {
        switch (JDK_ID) {
            case 4: {
                return J2ME ? "J2ME - JDBC for CDC/FP 1.1" : "J2SE 1.4 - JDBC 3.0";
            }
            case 5: {
                return "J2SE 1.4.2 - JDBC 3.0";
            }
            case 6: {
                return "J2SE 5.0 - JDBC 3.0";
            }
            case 7: {
                return "Java SE 6 - JDBC 4.0";
            }
            case 8: {
                return "Java SE 7 - JDBC 4.0";
            }
        }
        return "?-?";
    }

    private static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static final boolean isSunJVM() {
        String string = JVMInfo.getSystemProperty("java.vendor");
        return "Sun Microsystems Inc.".equals(string) || "Oracle Corporation".equals(string);
    }

    public static final boolean isIBMJVM() {
        return "IBM Corporation".equals(JVMInfo.getSystemProperty("java.vendor"));
    }

    public static void javaDump() {
        if (JVMInfo.isIBMJVM()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.ibm.jvm.Dump");
                final Method method = clazz.getMethod("JavaDump", new Class[0]);
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, MalformedURLException, InstantiationException, InvocationTargetException {
                        return method.invoke(null, new Object[0]);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        boolean bl;
        int n;
        String string;
        String string2;
        try {
            string2 = System.getProperty("java.specification.name");
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        try {
            string = System.getProperty("java.specification.version", "1.4");
        }
        catch (SecurityException securityException) {
            string = "1.4";
        }
        if (string2 != null && (string2.startsWith("J2ME") || string2.startsWith("CDC") || string2.indexOf("Profile") > -1 && string2.indexOf("Specification") > -1)) {
            n = 4;
            bl = true;
        } else {
            bl = false;
            if (string.equals("1.4")) {
                String string3 = System.getProperty("java.version", "1.4.0");
                n = JVMInfo.vmCheck(string3, "1.4.0") || JVMInfo.vmCheck(string3, "1.4.1") ? 4 : 5;
            } else if (string.equals("1.5")) {
                n = 6;
            } else if (string.equals("1.6")) {
                n = 7;
            } else if (string.equals("1.7")) {
                n = 8;
            } else {
                n = 4;
                try {
                    if (Float.parseFloat(string) > 1.6f) {
                        n = 7;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        JDK_ID = n;
        J2ME = bl;
    }
}

