/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemMessages;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class FileSystemSelectionArea {
    private Label fileSystemTitle;
    private ComboViewer fileSystems;

    public void createContents(Composite composite) {
        this.fileSystemTitle = new Label(composite, 0);
        this.fileSystemTitle.setText(FileSystemMessages.FileSystemSelection_title);
        this.fileSystems = new ComboViewer(composite, 8);
        this.fileSystems.getControl().setLayoutData((Object)new GridData(768));
        this.fileSystems.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private static final long serialVersionUID = -1016234770078283634L;

            public String getText(Object element) {
                return ((FileSystemConfiguration)element).getLabel();
            }
        });
        this.fileSystems.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private static final long serialVersionUID = -4602504832139703303L;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return FileSystemSupportRegistry.getInstance().getConfigurations();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fileSystems.setInput((Object)this);
        this.fileSystems.setSelection((ISelection)new StructuredSelection((Object)FileSystemSupportRegistry.getInstance().getDefaultConfiguration()));
    }

    public FileSystemConfiguration getSelectedConfiguration() {
        IStructuredSelection structured;
        ISelection selection = this.fileSystems.getSelection();
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            return (FileSystemConfiguration)structured.getFirstElement();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.fileSystemTitle.setEnabled(enabled);
        this.fileSystems.getControl().setEnabled(enabled);
    }
}

