/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GitProjectProperties {
    private final Properties gitProperties = new Properties();
    public static final String PROJECT_GIT_PROPERTY = "git.property";
    public static final String PROPERTY_LAST_COMMIT_SHA = "last.commit.sha";
    public static final String PROPERTY_GIT_REPOSITORY_URL = "git.repository.url";
    public static final String DB_DIRIGIBLE_USERS_S_GIT_S_REPOSITORY = "/db/dirigible/users/%s/git/%s";
    public static final String DB_DIRIGIBLE_USERS_S_WORKSPACE = "/db/dirigible/users/%s/workspace/";
    public static final String GIT_PROPERTY_FILE_LOCATION = "/db/dirigible/users/%s/git/%s/git.property";

    public GitProjectProperties(String URL2, String SHA) {
        this.gitProperties.setProperty(PROPERTY_GIT_REPOSITORY_URL, URL2);
        this.gitProperties.setProperty(PROPERTY_LAST_COMMIT_SHA, SHA);
    }

    public GitProjectProperties(InputStream in) throws IOException {
        this.load(in);
    }

    public void load(InputStream in) throws IOException {
        this.gitProperties.load(in);
    }

    public String getSHA() {
        return this.gitProperties.getProperty(PROPERTY_LAST_COMMIT_SHA);
    }

    public String getURL() {
        return this.gitProperties.getProperty(PROPERTY_GIT_REPOSITORY_URL);
    }

    public GitProjectProperties setSHA(String SHA) {
        this.gitProperties.setProperty(PROPERTY_LAST_COMMIT_SHA, SHA);
        return this;
    }

    public GitProjectProperties setURL(String URL2) {
        this.gitProperties.setProperty(PROPERTY_GIT_REPOSITORY_URL, URL2);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("git.repository.url=" + this.getURL() + "\n");
        result.append("last.commit.sha=" + this.getSHA());
        return result.toString();
    }

    public byte[] getContent() {
        return this.toString().getBytes();
    }
}

