/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.Arrays;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;

public class DomainFilterInterceptor
extends ChannelInterceptorBase {
    protected Membership membership = null;
    protected byte[] domain = new byte[0];

    @Override
    public void messageReceived(ChannelMessage msg) {
        super.messageReceived(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberAdded(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean notify = false;
        Membership membership = this.membership;
        synchronized (membership) {
            notify = Arrays.equals(this.domain, member.getDomain());
            if (notify) {
                notify = this.membership.memberAlive((MemberImpl)member);
            }
        }
        if (notify) {
            super.memberAdded(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean notify = false;
        Membership membership = this.membership;
        synchronized (membership) {
            notify = Arrays.equals(this.domain, member.getDomain());
            this.membership.removeMember((MemberImpl)member);
        }
        if (notify) {
            super.memberDisappeared(member);
        }
    }

    @Override
    public boolean hasMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.hasMembers();
    }

    @Override
    public Member[] getMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMembers();
    }

    @Override
    public Member getMember(Member mbr) {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMember(mbr);
    }

    @Override
    public Member getLocalMember(boolean incAlive) {
        return super.getLocalMember(incAlive);
    }

    protected synchronized void setupMembership() {
        if (this.membership == null) {
            this.membership = new Membership((MemberImpl)super.getLocalMember(true));
        }
    }

    public byte[] getDomain() {
        return this.domain;
    }

    public void setDomain(byte[] domain) {
        this.domain = domain;
    }

    public void setDomain(String domain) {
        if (domain == null) {
            return;
        }
        if (domain.startsWith("{")) {
            this.setDomain(org.apache.catalina.tribes.util.Arrays.fromString(domain));
        } else {
            this.setDomain(org.apache.catalina.tribes.util.Arrays.convert(domain));
        }
    }
}

