/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.PermissionsUtils;

public class ContentResetMaker {
    private static final Logger logger = Logger.getLogger(ContentResetMaker.class);

    public void doReset(HttpServletRequest request, IRepository repository) throws ServletException, IOException {
        if (!PermissionsUtils.isUserInRole((HttpServletRequest)request, (String)"Operator")) {
            String err = String.format("%s called, but the user does not have permissions to do this operation", "Reset");
            logger.debug(err);
            throw new ServletException(err);
        }
        logger.debug("Reset called...");
        repository.removeCollection("/db/dirigible/registry/");
        logger.debug("Reset - registry content removed.");
        repository.removeCollection("/db/dirigible/sandbox/");
        logger.debug("Reset - sandbox content removed.");
        repository.removeCollection("/db/dirigible/users/");
        logger.debug("Reset - users content removed.");
        logger.debug("Reset done.");
    }
}

