/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.HashMap;
import java.util.Map;

public class ContentTypeHelper {
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();
    private static final Map<String, String> BINARY_CONTENT_TYPES = new HashMap<String, String>();
    private static final Map<String, String> TEXT_CONTENT_TYPES = new HashMap<String, String>();
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";

    static {
        BINARY_CONTENT_TYPES.put("ai", "application/postscript");
        BINARY_CONTENT_TYPES.put("aif", "audio/x-aiff");
        BINARY_CONTENT_TYPES.put("aifc", "audio/x-aiff");
        BINARY_CONTENT_TYPES.put("aiff", "audio/x-aiff");
        BINARY_CONTENT_TYPES.put("apk", "application/vnd.android.package-archive");
        BINARY_CONTENT_TYPES.put("asf", "video/x-ms-asf");
        BINARY_CONTENT_TYPES.put("asr", "video/x-ms-asf");
        BINARY_CONTENT_TYPES.put("asx", "video/x-ms-asf");
        BINARY_CONTENT_TYPES.put("au", "audio/basic");
        BINARY_CONTENT_TYPES.put("avi", "video/x-msvideo");
        BINARY_CONTENT_TYPES.put("axs", "application/olescript");
        BINARY_CONTENT_TYPES.put("bcpio", "application/x-bcpio");
        BINARY_CONTENT_TYPES.put("bin", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("bmp", "image/bmp");
        BINARY_CONTENT_TYPES.put("cat", "application/vnd.ms-pkiseccat");
        BINARY_CONTENT_TYPES.put("cdf", "application/x-cdf");
        BINARY_CONTENT_TYPES.put("cdf", "application/x-netcdf");
        BINARY_CONTENT_TYPES.put("cer", "application/x-x509-ca-cert");
        BINARY_CONTENT_TYPES.put("class", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("clp", "application/x-msclip");
        BINARY_CONTENT_TYPES.put("cmx", "image/x-cmx");
        BINARY_CONTENT_TYPES.put("cod", "image/cis-cod");
        BINARY_CONTENT_TYPES.put("cpio", "application/x-cpio");
        BINARY_CONTENT_TYPES.put("crd", "application/x-mscardfile");
        BINARY_CONTENT_TYPES.put("crl", "application/pkix-crl");
        BINARY_CONTENT_TYPES.put("crt", "application/x-x509-ca-cert");
        BINARY_CONTENT_TYPES.put("csh", "application/x-csh");
        BINARY_CONTENT_TYPES.put("dcr", "application/x-director");
        BINARY_CONTENT_TYPES.put("der", "application/x-x509-ca-cert");
        BINARY_CONTENT_TYPES.put("dir", "application/x-director");
        BINARY_CONTENT_TYPES.put("dll", "application/x-msdownload");
        BINARY_CONTENT_TYPES.put("dms", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("doc", "application/msword");
        BINARY_CONTENT_TYPES.put("dot", "application/msword");
        BINARY_CONTENT_TYPES.put("dvi", "application/x-dvi");
        BINARY_CONTENT_TYPES.put("dxr", "application/x-director");
        BINARY_CONTENT_TYPES.put("eps", "application/postscript");
        BINARY_CONTENT_TYPES.put("evy", "application/envoy");
        BINARY_CONTENT_TYPES.put("exe", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("fif", "application/fractals");
        BINARY_CONTENT_TYPES.put("flr", "x-world/x-vrml");
        BINARY_CONTENT_TYPES.put("gif", "image/gif");
        BINARY_CONTENT_TYPES.put("gtar", "application/x-gtar");
        BINARY_CONTENT_TYPES.put("gz", "application/x-gzip");
        BINARY_CONTENT_TYPES.put("hdf", "application/x-hdf");
        BINARY_CONTENT_TYPES.put("hlp", "application/winhlp");
        BINARY_CONTENT_TYPES.put("hqx", "application/mac-binhex40");
        BINARY_CONTENT_TYPES.put("hta", "application/hta");
        BINARY_CONTENT_TYPES.put("ico", "image/x-icon");
        BINARY_CONTENT_TYPES.put("ief", "image/ief");
        BINARY_CONTENT_TYPES.put("iii", "application/x-iphone");
        BINARY_CONTENT_TYPES.put("ins", "application/x-internet-signup");
        BINARY_CONTENT_TYPES.put("isp", "application/x-internet-signup");
        BINARY_CONTENT_TYPES.put("jfif", "image/pipeg");
        BINARY_CONTENT_TYPES.put("jpe", "image/jpeg");
        BINARY_CONTENT_TYPES.put("jpeg", "image/jpeg");
        BINARY_CONTENT_TYPES.put("jpg", "image/jpeg");
        BINARY_CONTENT_TYPES.put("latex", "application/x-latex");
        BINARY_CONTENT_TYPES.put("lha", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("lsf", "video/x-la-asf");
        BINARY_CONTENT_TYPES.put("lsx", "video/x-la-asf");
        BINARY_CONTENT_TYPES.put("lzh", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("m13", "application/x-msmediaview");
        BINARY_CONTENT_TYPES.put("m14", "application/x-msmediaview");
        BINARY_CONTENT_TYPES.put("m3u", "audio/x-mpegurl");
        BINARY_CONTENT_TYPES.put("man", "application/x-troff-man");
        BINARY_CONTENT_TYPES.put("mdb", "application/x-msaccess");
        BINARY_CONTENT_TYPES.put("me", "application/x-troff-me");
        BINARY_CONTENT_TYPES.put("mht", "message/rfc822");
        BINARY_CONTENT_TYPES.put("mhtml", "message/rfc822");
        BINARY_CONTENT_TYPES.put("mid", "audio/mid");
        BINARY_CONTENT_TYPES.put("mny", "application/x-msmoney");
        BINARY_CONTENT_TYPES.put("mov", "video/quicktime");
        BINARY_CONTENT_TYPES.put("movie", "video/x-sgi-movie");
        BINARY_CONTENT_TYPES.put("mp2", "video/mpeg");
        BINARY_CONTENT_TYPES.put("mp3", "audio/mpeg");
        BINARY_CONTENT_TYPES.put("mpa", "video/mpeg");
        BINARY_CONTENT_TYPES.put("mpe", "video/mpeg");
        BINARY_CONTENT_TYPES.put("mpeg", "video/mpeg");
        BINARY_CONTENT_TYPES.put("mpg", "video/mpeg");
        BINARY_CONTENT_TYPES.put("mpp", "application/vnd.ms-project");
        BINARY_CONTENT_TYPES.put("mpv2", "video/mpeg");
        BINARY_CONTENT_TYPES.put("ms", "application/x-troff-ms");
        BINARY_CONTENT_TYPES.put("msg", "application/vnd.ms-outlook");
        BINARY_CONTENT_TYPES.put("mvb", "application/x-msmediaview");
        BINARY_CONTENT_TYPES.put("nc", "application/x-netcdf");
        BINARY_CONTENT_TYPES.put("nws", "message/rfc822");
        BINARY_CONTENT_TYPES.put("oda", "application/oda");
        BINARY_CONTENT_TYPES.put("p10", "application/pkcs10");
        BINARY_CONTENT_TYPES.put("p12", "application/x-pkcs12");
        BINARY_CONTENT_TYPES.put("p7b", "application/x-pkcs7-certificates");
        BINARY_CONTENT_TYPES.put("p7c", "application/x-pkcs7-mime");
        BINARY_CONTENT_TYPES.put("p7m", "application/x-pkcs7-mime");
        BINARY_CONTENT_TYPES.put("p7r", "application/x-pkcs7-certreqresp");
        BINARY_CONTENT_TYPES.put("p7s", "application/x-pkcs7-signature");
        BINARY_CONTENT_TYPES.put("pbm", "image/x-portable-bitmap");
        BINARY_CONTENT_TYPES.put("pdf", "application/pdf");
        BINARY_CONTENT_TYPES.put("pfx", "application/x-pkcs12");
        BINARY_CONTENT_TYPES.put("pgm", "image/x-portable-graymap");
        BINARY_CONTENT_TYPES.put("pko", "application/ynd.ms-pkipko");
        BINARY_CONTENT_TYPES.put("pma", "application/x-perfmon");
        BINARY_CONTENT_TYPES.put("pmc", "application/x-perfmon");
        BINARY_CONTENT_TYPES.put("pml", "application/x-perfmon");
        BINARY_CONTENT_TYPES.put("pmr", "application/x-perfmon");
        BINARY_CONTENT_TYPES.put("pmw", "application/x-perfmon");
        BINARY_CONTENT_TYPES.put("png", "image/png");
        BINARY_CONTENT_TYPES.put("pnm", "image/x-portable-anymap");
        BINARY_CONTENT_TYPES.put("pot", "application/vnd.ms-powerpoint");
        BINARY_CONTENT_TYPES.put("ppm", "image/x-portable-pixmap");
        BINARY_CONTENT_TYPES.put("pps", "application/vnd.ms-powerpoint");
        BINARY_CONTENT_TYPES.put("ppt", "application/vnd.ms-powerpoint");
        BINARY_CONTENT_TYPES.put("prf", "application/pics-rules");
        BINARY_CONTENT_TYPES.put("ps", "application/postscript");
        BINARY_CONTENT_TYPES.put("pub", "application/x-mspublisher");
        BINARY_CONTENT_TYPES.put("qt", "video/quicktime");
        BINARY_CONTENT_TYPES.put("ra", "audio/x-pn-realaudio");
        BINARY_CONTENT_TYPES.put("ram", "audio/x-pn-realaudio");
        BINARY_CONTENT_TYPES.put("ras", "image/x-cmu-raster");
        BINARY_CONTENT_TYPES.put("rgb", "image/x-rgb");
        BINARY_CONTENT_TYPES.put("rmi", "audio/mid");
        BINARY_CONTENT_TYPES.put("roff", "application/x-troff");
        BINARY_CONTENT_TYPES.put("scd", "application/x-msschedule");
        BINARY_CONTENT_TYPES.put("setpay", "application/set-payment-initiation");
        BINARY_CONTENT_TYPES.put("setreg", "application/set-registration-initiation");
        BINARY_CONTENT_TYPES.put("shar", "application/x-shar");
        BINARY_CONTENT_TYPES.put("sit", "application/x-stuffit");
        BINARY_CONTENT_TYPES.put("snd", "audio/basic");
        BINARY_CONTENT_TYPES.put("spc", "application/x-pkcs7-certificates");
        BINARY_CONTENT_TYPES.put("spl", "application/futuresplash");
        BINARY_CONTENT_TYPES.put("src", "application/x-wais-source");
        BINARY_CONTENT_TYPES.put("sst", "application/vnd.ms-pkicertstore");
        BINARY_CONTENT_TYPES.put("stl", "application/vnd.ms-pkistl");
        BINARY_CONTENT_TYPES.put("sv4cpio", "application/x-sv4cpio");
        BINARY_CONTENT_TYPES.put("sv4crc", "application/x-sv4crc");
        BINARY_CONTENT_TYPES.put("swf", "application/x-shockwave-flash");
        BINARY_CONTENT_TYPES.put("t", "application/x-troff");
        BINARY_CONTENT_TYPES.put("tar", "application/x-tar");
        BINARY_CONTENT_TYPES.put("tcl", "application/x-tcl");
        BINARY_CONTENT_TYPES.put("tex", "application/x-tex");
        BINARY_CONTENT_TYPES.put("texi", "application/x-texinfo");
        BINARY_CONTENT_TYPES.put("texinfo", "application/x-texinfo");
        BINARY_CONTENT_TYPES.put("tgz", "application/x-compressed");
        BINARY_CONTENT_TYPES.put("tif", "image/tiff");
        BINARY_CONTENT_TYPES.put("tiff", "image/tiff");
        BINARY_CONTENT_TYPES.put("tr", "application/x-troff");
        BINARY_CONTENT_TYPES.put("trm", "application/x-msterminal");
        BINARY_CONTENT_TYPES.put("ustar", "application/x-ustar");
        BINARY_CONTENT_TYPES.put("vrml", "x-world/x-vrml");
        BINARY_CONTENT_TYPES.put("wav", "audio/x-wav");
        BINARY_CONTENT_TYPES.put("wcm", "application/vnd.ms-works");
        BINARY_CONTENT_TYPES.put("wdb", "application/vnd.ms-works");
        BINARY_CONTENT_TYPES.put("wks", "application/vnd.ms-works");
        BINARY_CONTENT_TYPES.put("wmf", "application/x-msmetafile");
        BINARY_CONTENT_TYPES.put("wps", "application/vnd.ms-works");
        BINARY_CONTENT_TYPES.put("wri", "application/x-mswrite");
        BINARY_CONTENT_TYPES.put("wrl", "x-world/x-vrml");
        BINARY_CONTENT_TYPES.put("wrz", "x-world/x-vrml");
        BINARY_CONTENT_TYPES.put("xaf", "x-world/x-vrml");
        BINARY_CONTENT_TYPES.put("xbm", "image/x-xbitmap");
        BINARY_CONTENT_TYPES.put("xla", "application/vnd.ms-excel");
        BINARY_CONTENT_TYPES.put("xlc", "application/vnd.ms-excel");
        BINARY_CONTENT_TYPES.put("xlm", "application/vnd.ms-excel");
        BINARY_CONTENT_TYPES.put("xls", "application/vnd.ms-excel");
        BINARY_CONTENT_TYPES.put("xlt", "application/vnd.ms-excel");
        BINARY_CONTENT_TYPES.put("xlw", "application/vnd.ms-excel");
        BINARY_CONTENT_TYPES.put("xof", "x-world/x-vrml");
        BINARY_CONTENT_TYPES.put("xpm", "image/x-xpixmap");
        BINARY_CONTENT_TYPES.put("xwd", "image/x-xwindowdump");
        BINARY_CONTENT_TYPES.put("z", "application/x-compress");
        BINARY_CONTENT_TYPES.put("zip", "application/zip");
        BINARY_CONTENT_TYPES.put("ttf", "application/octet-stream");
        BINARY_CONTENT_TYPES.put("svg", "image/svg+xml");
        BINARY_CONTENT_TYPES.put("ttf", "application/x-font-ttf");
        BINARY_CONTENT_TYPES.put("otf", "application/x-font-opentype");
        BINARY_CONTENT_TYPES.put("woff", "application/font-woff");
        BINARY_CONTENT_TYPES.put("eot", "application/vnd.ms-fontobject");
        TEXT_CONTENT_TYPES.put("txt", DEFAULT_CONTENT_TYPE);
        TEXT_CONTENT_TYPES.put("xml", "text/xml");
        TEXT_CONTENT_TYPES.put("json", "application/json");
        TEXT_CONTENT_TYPES.put("js", "application/javascript");
        TEXT_CONTENT_TYPES.put("jslib", "application/javascript");
        TEXT_CONTENT_TYPES.put("table", "application/json");
        TEXT_CONTENT_TYPES.put("view", "application/json");
        TEXT_CONTENT_TYPES.put("entity", "application/json");
        TEXT_CONTENT_TYPES.put("ws", "application/json");
        TEXT_CONTENT_TYPES.put("routes", "text/xml");
        TEXT_CONTENT_TYPES.put("wsdl", "text/xml");
        TEXT_CONTENT_TYPES.put("xsl", "text/xml");
        TEXT_CONTENT_TYPES.put("xslt", "text/xml");
        TEXT_CONTENT_TYPES.put("bas", DEFAULT_CONTENT_TYPE);
        TEXT_CONTENT_TYPES.put("c", DEFAULT_CONTENT_TYPE);
        TEXT_CONTENT_TYPES.put("css", "text/css");
        TEXT_CONTENT_TYPES.put("etx", "text/x-setext");
        TEXT_CONTENT_TYPES.put("h", DEFAULT_CONTENT_TYPE);
        TEXT_CONTENT_TYPES.put("htm", "text/html");
        TEXT_CONTENT_TYPES.put("html", "text/html");
        TEXT_CONTENT_TYPES.put("htt", "text/webviewhtml");
        TEXT_CONTENT_TYPES.put("sct", "text/scriptlet");
        TEXT_CONTENT_TYPES.put("rtx", "text/richtext");
        TEXT_CONTENT_TYPES.put("rtf", "application/rtf");
        TEXT_CONTENT_TYPES.put("sh", "application/x-sh");
        TEXT_CONTENT_TYPES.put("stm", "text/html");
        TEXT_CONTENT_TYPES.put("tsv", "text/tab-separated-values");
        TEXT_CONTENT_TYPES.put("uls", "text/iuls");
        TEXT_CONTENT_TYPES.put("htc", "text/x-component");
        TEXT_CONTENT_TYPES.put("vcf", "text/x-vcard");
        TEXT_CONTENT_TYPES.put("wiki", "text/html");
        TEXT_CONTENT_TYPES.put("wikis", "text/html");
        TEXT_CONTENT_TYPES.put("md", "text/html");
        TEXT_CONTENT_TYPES.put("markdown", "text/html");
        TEXT_CONTENT_TYPES.put("mdown", "text/html");
        TEXT_CONTENT_TYPES.put("mkdn", "text/html");
        TEXT_CONTENT_TYPES.put("markdown", "text/html");
        TEXT_CONTENT_TYPES.put("mkd", "text/html");
        TEXT_CONTENT_TYPES.put("mdwn", "text/html");
        TEXT_CONTENT_TYPES.put("textile", "text/html");
        TEXT_CONTENT_TYPES.put("confluence", "text/html");
        TEXT_CONTENT_TYPES.put("tracwiki", "text/html");
        TEXT_CONTENT_TYPES.put("twiki", "text/html");
        CONTENT_TYPES.putAll(BINARY_CONTENT_TYPES);
        CONTENT_TYPES.putAll(TEXT_CONTENT_TYPES);
    }

    public static String getContentType(String extension) {
        if (extension == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        String contentType = CONTENT_TYPES.get(extension.toLowerCase());
        if (contentType == null) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        return contentType;
    }

    public static boolean isBinary(String contentType) {
        return BINARY_CONTENT_TYPES.containsValue(contentType);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return "";
        }
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex != -1) {
            return filename.substring(dotIndex + 1);
        }
        return "";
    }
}

