/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting.utils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.dirigible.repository.ext.db.DBSequenceUtils;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class DbUtils {
    private DataSource dataSource;
    private DBSequenceUtils dbSequenceUtils;

    public DbUtils(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dbSequenceUtils = new DBSequenceUtils(dataSource);
    }

    public int getNext(String sequenceName) throws SQLException {
        return this.dbSequenceUtils.getNext(sequenceName);
    }

    public int createSequence(String sequenceName, int start) throws SQLException {
        return this.dbSequenceUtils.createSequence(sequenceName, start);
    }

    public int dropSequence(String sequenceName) throws SQLException {
        return this.dbSequenceUtils.dropSequence(sequenceName);
    }

    public boolean existSequence(String sequenceName) throws SQLException {
        return this.dbSequenceUtils.existSequence(sequenceName);
    }

    public String createLimitAndOffset(String limit, String offset) throws SQLException {
        return this.createLimitAndOffset(NumberUtils.toInt((String)StringEscapeUtils.escapeSql((String)limit)), NumberUtils.toInt((String)StringEscapeUtils.escapeSql((String)offset)));
    }

    public String createLimitAndOffset(int limit, String offset) throws SQLException {
        return this.createLimitAndOffset(limit, NumberUtils.toInt((String)StringEscapeUtils.escapeSql((String)offset)));
    }

    public String createLimitAndOffset(String limit, int offset) throws SQLException {
        return this.createLimitAndOffset(NumberUtils.toInt((String)StringEscapeUtils.escapeSql((String)limit)), offset);
    }

    public String createLimitAndOffset(int limit, int offset) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            String productName = connection.getMetaData().getDatabaseProductName();
            IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier((String)productName);
            String string = dialectSpecifier.createLimitAndOffset(limit, offset);
            return string;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public String createTopAndStart(int limit, int offset) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            String productName = connection.getMetaData().getDatabaseProductName();
            IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier((String)productName);
            String string = dialectSpecifier.createTopAndStart(limit, offset);
            return string;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Date createDate(long value) {
        return new Date(value);
    }

    public Time createTime(long value) {
        return new Time(value);
    }

    public Timestamp createTimestamp(long value) {
        return new Timestamp(value);
    }
}

