/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.debug;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.ext.debug.BreakpointsMetadata;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.debug.IDebugController;

public class DebugModel {
    public static final String DEBUG_MODEL = "debug.model";
    private IDebugController debugController;
    private BreakpointsMetadata breakpointsMetadata;
    private List<DebugSessionModel> sessions;
    private DebugSessionModel activeSession;

    public DebugModel(IDebugController debugController) {
        this.debugController = debugController;
        this.breakpointsMetadata = new BreakpointsMetadata(this);
        this.sessions = new ArrayList<DebugSessionModel>();
    }

    public IDebugController getDebugController() {
        return this.debugController;
    }

    public void setDebugController(IDebugController debugController) {
        this.debugController = debugController;
    }

    public DebugSessionModel createSession() {
        DebugSessionModel session = new DebugSessionModel(this);
        this.sessions.add(session);
        return session;
    }

    public void removeSession(DebugSessionModel session) {
        session.release();
        this.sessions.remove(session);
    }

    public List<DebugSessionModel> getSessions() {
        return this.sessions;
    }

    public DebugSessionModel getActiveSession() {
        return this.activeSession;
    }

    public void setActiveSession(DebugSessionModel activeSession) {
        this.activeSession = activeSession;
    }

    public DebugSessionModel getSessionByExecutionId(String executionId) {
        for (DebugSessionModel debugSessionModel : this.sessions) {
            if (debugSessionModel.getExecutionId() == null || !debugSessionModel.getExecutionId().equals(executionId)) continue;
            return debugSessionModel;
        }
        return null;
    }

    public BreakpointsMetadata getBreakpointsMetadata() {
        return this.breakpointsMetadata;
    }

    public void setBreakpointsMetadata(BreakpointsMetadata breakpointMetadata) {
        this.breakpointsMetadata = breakpointMetadata;
    }
}

