/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateModel;

public class HtmlTemplateGenerator
extends TemplateGenerator {
    private static final String LOG_TAG = "HTML_GENERATOR";
    private HtmlTemplateModel model;

    public HtmlTemplateGenerator(HtmlTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("pageTitle", this.model.getPageTitle());
        return parameters;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    public void generate() throws Exception {
        super.generate();
        if ("/org/eclipse/dirigible/ide/template/ui/html/templates/index-page.html".equals(this.model.getTemplate().getLocation())) {
            this.copyFile("main.menu", "/org/eclipse/dirigible/ide/template/ui/html/templates/main.menu", HtmlTemplateGenerator.class);
            this.copyFile("sample.html", "/org/eclipse/dirigible/ide/template/ui/html/templates/sample.html", HtmlTemplateGenerator.class);
            this.generateFile("/org/eclipse/dirigible/ide/template/ui/html/templates/header.html", this.model.getTargetLocation(), "header.html");
            this.generateFile("/org/eclipse/dirigible/ide/template/ui/html/templates/footer.html", this.model.getTargetLocation(), "footer.html");
        }
    }

    protected byte[] afterGeneration(byte[] bytes) {
        String content = new String(bytes);
        content = content.replace("\\$", "$");
        content = content.replace("\\{", "{");
        content = content.replace("\\}", "}");
        content = content.replace("\\[", "[");
        content = content.replace("\\]", "]");
        content = content.replace("\\.", ".");
        byte[] result = content.getBytes();
        return result;
    }
}

