/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.launch;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.LaunchUtil;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class LaunchConfig
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!"run".equalsIgnoreCase(mode)) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)Messages.Launch_DebugNotSupported_Title, (String)Messages.Launch_DebugNotSupported_Body));
        }
        String mainClass = configuration.getAttribute("main_class", "main.dart");
        String sdk = configuration.getAttribute("sdk_location", "");
        String projectName = configuration.getAttribute("selected_project", "");
        IProject project = this.getProject(projectName);
        if (!project.exists()) {
            MessageDialog.openError(null, (String)Messages.Launch_NoProjectSelected_Title, (String)Messages.Launch_NoProjectSelected_Body);
            return;
        }
        LaunchUtil.launchDartFile(launch, sdk, String.valueOf(project.getLocation().toOSString()) + File.separatorChar + mainClass);
    }

    public IProject getProject(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getProject(name);
    }
}

