/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;

final class RegExpSourceList {
    private final List<RegExpSource> items = new ArrayList<RegExpSource>();
    private boolean hasAnchors;
    private @Nullable CompiledRule cached;
    private final CompiledRule[][] anchorCache = new CompiledRule[2][2];

    RegExpSourceList() {
    }

    private void disposeCache() {
        this.cached = null;
        this.anchorCache[0][0] = null;
        this.anchorCache[0][1] = null;
        this.anchorCache[1][0] = null;
        this.anchorCache[1][1] = null;
    }

    void add(RegExpSource item) {
        this.items.add(item);
        if (!this.hasAnchors) {
            this.hasAnchors = item.hasAnchor();
        }
    }

    void remove(RegExpSource item) {
        this.items.add(0, item);
        if (!this.hasAnchors) {
            this.hasAnchors = item.hasAnchor();
        }
    }

    int length() {
        return this.items.size();
    }

    void setSource(int index, String newSource) {
        RegExpSource r = this.items.get(index);
        if (!Objects.equals(r.getSource(), newSource)) {
            this.disposeCache();
            r.setSource(newSource);
        }
    }

    CompiledRule compile() {
        CompiledRule cached = this.cached;
        if (cached == null) {
            List<String> regexps = this.items.stream().map(RegExpSource::getSource).collect(Collectors.toList());
            cached = this.cached = new CompiledRule(regexps, this.getRules());
        }
        return cached;
    }

    CompiledRule compileAG(boolean allowA, boolean allowG) {
        int indexG;
        if (!this.hasAnchors) {
            return this.compile();
        }
        int indexA = allowA ? 1 : 0;
        CompiledRule rule = this.anchorCache[indexA][indexG = allowG ? 1 : 0];
        if (rule == null) {
            CompiledRule compiledRule = this.resolveAnchors(allowA, allowG);
            this.anchorCache[indexA][indexG] = compiledRule;
            rule = compiledRule;
        }
        return rule;
    }

    private CompiledRule resolveAnchors(boolean allowA, boolean allowG) {
        List<String> regexps = this.items.stream().map(e -> e.resolveAnchors(allowA, allowG)).collect(Collectors.toList());
        return new CompiledRule(regexps, this.getRules());
    }

    private int[] getRules() {
        int[] ruleIds = new int[this.items.size()];
        int i = 0;
        while (i < ruleIds.length) {
            ruleIds[i] = this.items.get((int)i).ruleId;
            ++i;
        }
        return ruleIds;
    }
}

